/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.xml;

import java.net.URI;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum AllowedSchemaPatterns {
    XOEV("^urn:xoev-de:[a-z0-9()+,.:=@;$_!*'%/?#-]+$");

    private final String urnPattern;

    private AllowedSchemaPatterns(String urnPattern) {
        this.urnPattern = urnPattern;
    }

    public static boolean canBeValidated(URI schemaUrn) {
        return Arrays.stream(AllowedSchemaPatterns.values()).map(pattern -> Pattern.compile(pattern.urnPattern).matcher(schemaUrn.toString())).anyMatch(Matcher::matches);
    }

    public static boolean cannotBeValidated(URI schemaUrn) {
        return !AllowedSchemaPatterns.canBeValidated(schemaUrn);
    }
}

