/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.virusscan.process;

import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.core.io.ProcessRunner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClamAVProcessResultParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVProcessResultParser.class);
    private static final Pattern VIRUS_PATTERN = Pattern.compile("^(.+):\\s+(.+)\\s+FOUND$");
    private static final Pattern CLEAN_PATTERN = Pattern.compile("^(.+):\\s+OK$");
    private static final Pattern ERROR_PATTERN = Pattern.compile("^(.+):\\s+(.+)$");
    private static final Pattern SUMMARY_PATTERN = Pattern.compile("^----------- SCAN SUMMARY -----------$");

    public VirusScanResult parseResult(ProcessRunner.Result processResult) {
        if (processResult == null) {
            LOGGER.error("Process result is null");
            return VirusScanResult.ofScanFailed("Process result is null");
        }
        if (processResult.exitCode == -1) {
            String errorMessage = "ClamAV process failed to execute due to: " + processResult.error;
            LOGGER.error(errorMessage);
            return VirusScanResult.ofScanFailed(errorMessage);
        }
        String output = processResult.output;
        if (output == null || output.trim().isEmpty()) {
            LOGGER.warn("ClamAV process returned empty output");
            return VirusScanResult.ofScanFailed("Empty output from ClamAV process");
        }
        LOGGER.debug("Parsing ClamAV output");
        return this.parseOutput(output);
    }

    private VirusScanResult parseOutput(String output) {
        VirusScanResult currentResult = null;
        for (String rawLine : output.split("\\r?\\n")) {
            String line = rawLine.trim();
            if (line.isEmpty()) continue;
            if (SUMMARY_PATTERN.matcher(line).matches()) break;
            currentResult = this.parseLine(line);
            if (!currentResult.isInfected() && !currentResult.isScanFailed()) continue;
            return currentResult;
        }
        return currentResult;
    }

    private VirusScanResult parseLine(String line) {
        Matcher virusMatcher = VIRUS_PATTERN.matcher(line);
        if (virusMatcher.matches()) {
            String filename = virusMatcher.group(1);
            String signature = virusMatcher.group(2);
            LOGGER.warn("Malware detected in {}: {}", (Object)filename, (Object)signature);
            return VirusScanResult.ofInfected("Malware detected in " + filename, signature);
        }
        Matcher cleanMatcher = CLEAN_PATTERN.matcher(line);
        if (cleanMatcher.matches()) {
            String filename = cleanMatcher.group(1);
            LOGGER.debug("File {} is clean", (Object)filename);
            return VirusScanResult.ofClean(line);
        }
        Matcher errorMatcher = ERROR_PATTERN.matcher(line);
        if (errorMatcher.matches()) {
            String filename = errorMatcher.group(1);
            String errorMessage = errorMatcher.group(2);
            LOGGER.error("ClamAV error for {}: {}", (Object)filename, (Object)errorMessage);
            return VirusScanResult.ofScanFailed("ClamAV error: " + errorMessage);
        }
        return VirusScanResult.ofScanFailed("ClamAV result output did not contain any matching data");
    }
}

