/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.virusscan.deamon.socket;

import dev.fitko.fitconnect.core.validation.virusscan.deamon.ClamAVDeamonConfig;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.socket.ClamAVSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class DefaultClamAVSocketFactory
implements ClamAVSocketFactory {
    @Override
    public Socket createSocket(ClamAVDeamonConfig config) throws IOException {
        Socket socket = new Socket();
        this.configureSocket(socket, config);
        this.connect(socket, config);
        return socket;
    }

    private void configureSocket(Socket socket, ClamAVDeamonConfig config) throws IOException {
        socket.setSoTimeout(config.getSocketTimeoutMs());
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
    }

    private void connect(Socket socket, ClamAVDeamonConfig config) throws IOException {
        String host = config.getHost();
        int port = config.getPort() <= 0 ? ClamAVDeamonConfig.defaultConfig().getPort() : config.getPort();
        int connectionTimeoutMs = config.getConnectionTimeoutMs();
        socket.connect(new InetSocketAddress(host, port), connectionTimeoutMs);
    }
}

