/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.virusscan.deamon.response;

import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.response.ClamAVStreamResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClamAVDeamonResultParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVDeamonResultParser.class);

    public VirusScanResult parseClamAVResponse(InputStream responseData) throws IOException {
        String response = new String(responseData.readAllBytes(), StandardCharsets.UTF_8).trim();
        LOGGER.debug("Raw ClamAV response: '{}'", (Object)response);
        if (ClamAVStreamResponse.ERROR.isInResponse(response)) {
            return VirusScanResult.ofScanFailed("ClamAV scan error: " + response);
        }
        if (ClamAVStreamResponse.STREAM_PREFIX.isStartOfResponse(response)) {
            return this.parseScanResult(response);
        }
        LOGGER.warn("Unexpected ClamAV response format: '{}'", (Object)response);
        return VirusScanResult.ofScanFailed("Unknown response format: " + response);
    }

    public VirusScanResult parseScanResult(String scanResponse) {
        if (ClamAVStreamResponse.OK.isEndOfResponse(scanResponse)) {
            return VirusScanResult.ofClean(scanResponse);
        }
        if (ClamAVStreamResponse.FOUND.isInResponse(scanResponse)) {
            return VirusScanResult.ofInfected(scanResponse, this.extractVirusSignature(scanResponse));
        }
        LOGGER.warn("Unexpected stream result format: '{}'", (Object)scanResponse);
        return VirusScanResult.ofScanFailed("Unknown stream response format: " + scanResponse);
    }

    public String extractVirusSignature(String response) {
        try {
            int colonIndex = response.indexOf(":");
            int foundIndex = response.indexOf(ClamAVStreamResponse.FOUND.getValue());
            if (colonIndex >= 0 && foundIndex > colonIndex) {
                return response.substring(colonIndex + 1, foundIndex).trim();
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.warn("Failed to extract virus name from response: {}", (Object)response, (Object)e);
        }
        return "Unknown";
    }
}

