/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.virusscan;

import dev.fitko.fitconnect.api.config.virusscan.VirusScannerConfig;
import dev.fitko.fitconnect.api.config.virusscan.VirusScannerMode;
import dev.fitko.fitconnect.api.exceptions.internal.VirusScanException;
import dev.fitko.fitconnect.api.services.validation.VirusScanService;
import dev.fitko.fitconnect.core.validation.virusscan.ClamAVDeamonScanner;
import dev.fitko.fitconnect.core.validation.virusscan.ClamAVProcessScanner;
import dev.fitko.fitconnect.core.validation.virusscan.NoOpVirusScanner;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.ClamAVDeamonConfig;
import dev.fitko.fitconnect.core.validation.virusscan.process.ClamAVProcessConfig;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirusScannerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirusScannerFactory.class);

    private VirusScannerFactory() {
    }

    public static VirusScanService createScanner(VirusScannerMode scanMode, VirusScannerConfig virusScannerConfig) throws VirusScanException {
        Objects.requireNonNull(scanMode, "Scan mode must not be null");
        LOGGER.info("Creating virus scanner of type: {}", (Object)scanMode.getValue());
        try {
            switch (scanMode) {
                case CLAMAV_DAEMON: {
                    return VirusScannerFactory.buildClamAVDeamonScanner(virusScannerConfig);
                }
                case CLAMAV_PROCESS: {
                    return VirusScannerFactory.buildClamAVProcessScanner(virusScannerConfig);
                }
                case NO_OP: {
                    return new NoOpVirusScanner();
                }
            }
            throw new VirusScanException("Unsupported virus scanner type: " + String.valueOf((Object)scanMode));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create virus scanner of type: {}", (Object)scanMode, (Object)e);
            throw new VirusScanException("Failed to create virus scanner: " + e.getMessage(), e);
        }
    }

    private static ClamAVProcessScanner buildClamAVProcessScanner(VirusScannerConfig virusScannerConfig) {
        return new ClamAVProcessScanner(Optional.ofNullable(virusScannerConfig.getClamAVProcessConfig()).orElse(ClamAVProcessConfig.defaultConfig()));
    }

    private static ClamAVDeamonScanner buildClamAVDeamonScanner(VirusScannerConfig virusScannerConfig) {
        return new ClamAVDeamonScanner(Optional.ofNullable(virusScannerConfig.getClamAVDeamonConfig()).orElse(ClamAVDeamonConfig.defaultConfig()));
    }
}

