/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.virusscan;

import dev.fitko.fitconnect.api.domain.validation.VirusScanEngineInfo;
import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.api.exceptions.internal.VirusScanException;
import dev.fitko.fitconnect.api.services.validation.VirusScanService;
import dev.fitko.fitconnect.core.io.ProcessRunner;
import dev.fitko.fitconnect.core.utils.Preconditions;
import dev.fitko.fitconnect.core.utils.StopWatch;
import dev.fitko.fitconnect.core.validation.virusscan.process.ClamAVProcessConfig;
import dev.fitko.fitconnect.core.validation.virusscan.process.ClamAVProcessResultParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClamAVProcessScanner
implements VirusScanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVProcessScanner.class);
    private final ClamAVProcessConfig config;
    private final ClamAVProcessResultParser resultParser;

    public ClamAVProcessScanner(ClamAVProcessConfig config) {
        this.config = config != null ? config : ClamAVProcessConfig.defaultConfig();
        this.resultParser = new ClamAVProcessResultParser();
        LOGGER.info("Initialized ClamAV process scanner with executable: {}", (Object)this.config.getExecutablePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirusScanResult scanBytes(byte[] data) throws VirusScanException {
        Preconditions.checkArgument(data == null, () -> new VirusScanException("Data bytes must not be null"));
        LOGGER.debug("Scanning byte array of size: {}", (Object)data.length);
        Path tempFile = this.createTemporaryFile();
        try {
            Files.write(tempFile, data, StandardOpenOption.CREATE);
            VirusScanResult virusScanResult = this.scanFile(tempFile);
            this.cleanupTemporaryFile(tempFile);
            return virusScanResult;
        }
        catch (Throwable throwable) {
            try {
                this.cleanupTemporaryFile(tempFile);
                throw throwable;
            }
            catch (IOException e) {
                throw new VirusScanException("Failed to create temporary file for scanning", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirusScanResult scanStream(InputStream inputStream) throws VirusScanException {
        Preconditions.checkArgument(inputStream == null, () -> new VirusScanException("Input stream must not be null"));
        LOGGER.debug("Scanning input stream");
        Path tempFile = this.createTemporaryFile();
        try {
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            VirusScanResult virusScanResult = this.scanFile(tempFile);
            this.cleanupTemporaryFile(tempFile);
            return virusScanResult;
        }
        catch (Throwable throwable) {
            try {
                this.cleanupTemporaryFile(tempFile);
                throw throwable;
            }
            catch (IOException e) {
                throw new VirusScanException("Failed to create temporary file for scanning", e);
            }
        }
    }

    @Override
    public VirusScanResult scanFile(Path filePath) throws VirusScanException {
        Preconditions.checkArgument(filePath == null, () -> new VirusScanException("File path must not be null"));
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new VirusScanException("File does not exist: " + String.valueOf(filePath));
        }
        LOGGER.debug("Scanning file: {}", (Object)filePath);
        List<String> command = this.buildScanCommand(filePath.toString());
        long start = StopWatch.start();
        ProcessRunner.Result result = ProcessRunner.runCommand(command);
        LOGGER.debug("Scanning for viruses took {}", (Object)StopWatch.stop(start));
        return this.resultParser.parseResult(result);
    }

    @Override
    public boolean isAvailable() {
        try {
            ProcessRunner.Result result = ProcessRunner.runCommand(List.of(this.config.getExecutablePath(), "--version"));
            return result.exitCode == 0 && result.output != null && result.output.contains("ClamAV");
        }
        catch (Exception e) {
            LOGGER.debug("ClamAV availability check failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public VirusScanEngineInfo getEngineInfo() {
        try {
            ProcessRunner.Result result = ProcessRunner.runCommand(List.of(this.config.getExecutablePath(), "--version"));
            if (result.exitCode == 0 && result.output != null && result.output.contains("ClamAV")) {
                String version = Arrays.stream(result.output.split("\\r?\\n")).map(String::trim).filter(line -> line.startsWith("ClamAV")).findFirst().orElse(null);
                return new VirusScanEngineInfo("ClamAV", version != null ? version : result.output.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get ClamAV version info", (Throwable)e);
        }
        return null;
    }

    private List<String> buildScanCommand(String filePath) {
        List<String> command = List.of(this.config.getExecutablePath(), filePath);
        LOGGER.debug("Built ClamAV command: {}", (Object)String.join((CharSequence)" ", command));
        return command;
    }

    private Path createTemporaryFile() throws IOException {
        Path tempDir = Path.of(this.config.getTempDirectory(), new String[0]);
        if (!Files.exists(tempDir, new LinkOption[0])) {
            Files.createDirectories(tempDir, new FileAttribute[0]);
            LOGGER.debug("Created custom temporary directory: {}", (Object)tempDir);
        }
        if (!Files.isWritable(tempDir)) {
            throw new IOException("Custom temporary directory is not writable: " + String.valueOf(tempDir));
        }
        return Files.createTempFile("clamav_scan_", ".tmp", new FileAttribute[0]);
    }

    private void cleanupTemporaryFile(Path tempFile) {
        try {
            Files.deleteIfExists(tempFile);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete temporary file: {}", (Object)tempFile, (Object)e);
        }
    }
}

