/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation.virusscan;

import dev.fitko.fitconnect.api.domain.validation.VirusScanEngineInfo;
import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.api.exceptions.internal.VirusScanException;
import dev.fitko.fitconnect.api.services.validation.VirusScanService;
import dev.fitko.fitconnect.core.utils.Preconditions;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.ClamAVDeamonConfig;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.ClamAVStreamCommand;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.response.ClamAVDeamonResultParser;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.socket.ClamAVSocketFactory;
import dev.fitko.fitconnect.core.validation.virusscan.deamon.socket.DefaultClamAVSocketFactory;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClamAVDeamonScanner
implements VirusScanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVDeamonScanner.class);
    private final ClamAVDeamonConfig config;
    private final ClamAVDeamonResultParser resultHandler;
    private final ClamAVSocketFactory socketFactory;

    public ClamAVDeamonScanner() {
        this(ClamAVDeamonConfig.defaultConfig(), new ClamAVDeamonResultParser(), new DefaultClamAVSocketFactory());
    }

    public ClamAVDeamonScanner(ClamAVDeamonConfig config) {
        this.config = config != null ? config : ClamAVDeamonConfig.defaultConfig();
        this.resultHandler = new ClamAVDeamonResultParser();
        this.socketFactory = new DefaultClamAVSocketFactory();
        LOGGER.info("Setup new ClamAV scanner at {}:{}", (Object)this.config.getHost(), (Object)this.config.getPort());
    }

    public ClamAVDeamonScanner(ClamAVDeamonConfig config, ClamAVDeamonResultParser resultHandler, ClamAVSocketFactory socketFactory) {
        this.config = config != null ? config : ClamAVDeamonConfig.defaultConfig();
        this.resultHandler = resultHandler;
        this.socketFactory = socketFactory;
        LOGGER.info("Setup new ClamAV scanner at {}:{}", (Object)this.config.getHost(), (Object)this.config.getPort());
    }

    @Override
    public VirusScanResult scanBytes(byte[] data) throws VirusScanException {
        Preconditions.checkArgument(data == null, () -> new VirusScanException("data bytes must not be null"));
        return this.scanStream(new ByteArrayInputStream(data));
    }

    @Override
    public VirusScanResult scanFile(Path filePath) throws VirusScanException {
        Preconditions.checkArgument(filePath == null, () -> new VirusScanException("filePath must not be null"));
        try {
            return this.scanStream(Files.newInputStream(filePath, new OpenOption[0]));
        }
        catch (IOException e) {
            LOGGER.error("Reading file from path {} failed", (Object)filePath);
            throw new VirusScanException(e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public VirusScanResult scanStream(InputStream inputStream) throws VirusScanException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isAvailable() {
        try {
            String response = this.sendCommandToClamAV(ClamAVStreamCommand.PING);
            return response != null && response.trim().equalsIgnoreCase(ClamAVStreamCommand.PONG.getAsString());
        }
        catch (IOException e) {
            LOGGER.error("Network error connecting to ClamAV deamon {}:{}", new Object[]{this.config.getHost(), this.config.getPort(), e});
            return false;
        }
    }

    @Override
    public VirusScanEngineInfo getEngineInfo() {
        try {
            return new VirusScanEngineInfo("ClamAV", this.sendCommandToClamAV(ClamAVStreamCommand.VERSION));
        }
        catch (Exception e) {
            LOGGER.error("Failed to get ClamAV version info", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private String sendCommandToClamAV(ClamAVStreamCommand cmd) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void streamDataToClamAV(InputStream inputStream, OutputStream outStream) throws IOException {
        int bytesRead;
        outStream.write(ClamAVStreamCommand.IN_STREAM.getAsBytes());
        outStream.flush();
        byte[] readingBuffer = new byte[this.config.getReadBufferSize()];
        DataOutputStream dataOutputStream = new DataOutputStream(outStream);
        while ((bytesRead = inputStream.read(readingBuffer)) != -1) {
            dataOutputStream.writeInt(bytesRead);
            dataOutputStream.write(readingBuffer, 0, bytesRead);
        }
        outStream.write(ClamAVStreamCommand.END_STREAM.getAsBytes());
        outStream.flush();
    }

    private static /* synthetic */ RuntimeException lambda$scanStream$2() {
        return new VirusScanException("inputStream must not be null");
    }
}

