/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.Error;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SchemaRegistryConfig;
import com.networknt.schema.SpecificationVersion;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import dev.fitko.fitconnect.api.domain.model.destination.DestinationReplyChannels;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.destination.Service;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.AttachmentHashMismatch;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.IncorrectAttachmentAuthenticationTag;
import dev.fitko.fitconnect.api.domain.model.event.problems.data.DataHashMismatch;
import dev.fitko.fitconnect.api.domain.model.event.problems.data.DataJsonSyntaxViolation;
import dev.fitko.fitconnect.api.domain.model.event.problems.data.DataSchemaViolation;
import dev.fitko.fitconnect.api.domain.model.event.problems.data.DataXmlSyntaxViolation;
import dev.fitko.fitconnect.api.domain.model.event.problems.data.IncorrectDataAuthenticationTag;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.AttachmentsMismatch;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.IncorrectMetadataAuthenticationTag;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.MetadataJsonSyntaxViolation;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.MetadataSchemaViolation;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.MissingData;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.UnsupportedDataSchema;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.UnsupportedMetadataSchema;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.UnsupportedReplyChannel;
import dev.fitko.fitconnect.api.domain.model.event.problems.metadata.UnsupportedService;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.ApiAttachment;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.AttachmentForValidation;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import dev.fitko.fitconnect.api.domain.model.metadata.data.Data;
import dev.fitko.fitconnect.api.domain.model.metadata.data.MimeType;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.domain.model.submission.PublicService;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.internal.DataIntegrityException;
import dev.fitko.fitconnect.api.exceptions.internal.SchemaNotFoundException;
import dev.fitko.fitconnect.api.exceptions.internal.ValidationException;
import dev.fitko.fitconnect.api.services.crypto.MessageDigestService;
import dev.fitko.fitconnect.api.services.schema.SchemaProvider;
import dev.fitko.fitconnect.api.services.validation.ValidationService;
import dev.fitko.fitconnect.core.validation.xml.XmlSchemaValidator;
import dev.fitko.fitconnect.jwkvalidator.JWKValidator;
import dev.fitko.fitconnect.jwkvalidator.exceptions.JWKValidationException;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DefaultValidationService
implements ValidationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultValidationService.class);
    private static final ObjectMapper MAPPER = DefaultValidationService.createObjectMapper();
    private static final SchemaRegistryConfig VALIDATORS_CONFIG = ((SchemaRegistryConfig.Builder)((SchemaRegistryConfig.Builder)SchemaRegistryConfig.builder().formatAssertionsEnabled(Boolean.valueOf(true))).locale(Locale.US)).build();
    private static final SchemaRegistry SCHEMA_REGISTRY_DRAFT_2020 = SchemaRegistry.withDefaultDialect((SpecificationVersion)SpecificationVersion.DRAFT_2020_12, builder -> builder.schemaRegistryConfig(VALIDATORS_CONFIG));
    private static final SchemaRegistry SCHEMA_REGISTRY_DRAFT_2017 = SchemaRegistry.withDefaultDialect((SpecificationVersion)SpecificationVersion.DRAFT_7, builder -> builder.schemaRegistryConfig(VALIDATORS_CONFIG));
    private final MessageDigestService messageDigestService;
    private final SchemaProvider schemaProvider;
    private final ApplicationConfig config;
    private final JWKValidator jwkValidator;
    private final XmlSchemaValidator xmlSchemaValidator;

    public DefaultValidationService(ApplicationConfig config, MessageDigestService messageDigestService, SchemaProvider schemaProvider, XmlSchemaValidator xmlSchemaValidator, List<String> trustedRootCertificates) {
        this.config = config;
        this.messageDigestService = messageDigestService;
        this.schemaProvider = schemaProvider;
        this.xmlSchemaValidator = xmlSchemaValidator;
        this.jwkValidator = this.createValidator(config, trustedRootCertificates);
    }

    @Override
    public ValidationResult validatePublicKey(RSAKey publicKey, KeyOperation keyOperation) {
        return this.validatePublicKey(publicKey, null, keyOperation);
    }

    @Override
    public ValidationResult validatePublicKey(RSAKey publicKey, Date validationDate, KeyOperation keyOperation) {
        try {
            return this.validateKey(publicKey, validationDate, keyOperation);
        }
        catch (Exception e) {
            return ValidationResult.error(e);
        }
    }

    @Override
    public ValidationResult validateSetEventSchema(String setEventPayload) {
        try {
            JsonNode inputNode = MAPPER.readTree(setEventPayload);
            URI schemaUri = URI.create(inputNode.get("$schema").asText());
            if (this.schemaProvider.isAllowedSetSchema(schemaUri)) {
                return this.validate2020JsonSchema(this.schemaProvider.loadSetSchema(this.config.getSetSchemaWriteVersion()), inputNode);
            }
            return ValidationResult.error(new SchemaNotFoundException("SET payload schema not supported: " + String.valueOf(schemaUri)));
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            return ValidationResult.error((Exception)e);
        }
    }

    @Override
    public ValidationResult validateMetadataSchema(Metadata metadata) {
        if (metadata.getSchema() == null) {
            return ValidationResult.ok();
        }
        ValidationResult schemaAllowance = this.validateSchemaAllowance(metadata.getSchema());
        if (schemaAllowance.hasProblems()) {
            return schemaAllowance;
        }
        return this.loadSchemaAndValidate(metadata);
    }

    @Override
    public ValidationResult validateDestinationSchema(Map<String, Object> destinationPayload) {
        try {
            String destinationPayloadJson = MAPPER.writeValueAsString(destinationPayload);
            JsonNode inputNode = MAPPER.readTree(destinationPayloadJson);
            String schema = this.schemaProvider.loadDestinationSchema(this.config.getDestinationSchemaUri());
            return this.returnValidationResult(SCHEMA_REGISTRY_DRAFT_2017.getSchema(schema).validate(inputNode));
        }
        catch (JsonProcessingException e) {
            return ValidationResult.error((Exception)((Object)e));
        }
    }

    @Override
    public ValidationResult validateHashIntegrity(String originalHexHash, byte[] data) {
        try {
            boolean hashesAreNotEqual;
            byte[] originalHash = this.messageDigestService.fromHexString(originalHexHash);
            boolean bl = hashesAreNotEqual = !this.messageDigestService.verify(originalHash, data);
            if (hashesAreNotEqual) {
                return ValidationResult.error(new DataIntegrityException("Metadata contains invalid hash value"));
            }
            return ValidationResult.ok();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return ValidationResult.error(e);
        }
    }

    @Override
    public ValidationResult validateHashIntegrity(String originalHexHash, InputStream inputStream) {
        try {
            boolean hashesAreNotEqual;
            byte[] originalHash = this.messageDigestService.fromHexString(originalHexHash);
            boolean bl = hashesAreNotEqual = !this.messageDigestService.verify(originalHash, inputStream);
            if (hashesAreNotEqual) {
                return ValidationResult.error(new DataIntegrityException("Metadata contains invalid hash value"));
            }
            return ValidationResult.ok();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return ValidationResult.error(e);
        }
    }

    @Override
    public ValidationResult validateJsonSubmissionDataSchema(byte[] json, URI schemaUri) {
        if (this.config.isSkipSubmissionDataValidation()) {
            LOGGER.warn("Submission data validation is deactivated. This should be done only on secure test environments.");
            return ValidationResult.ok();
        }
        String schema = this.schemaProvider.loadSubmissionDataSchema(schemaUri);
        try {
            return this.returnValidationResult(SCHEMA_REGISTRY_DRAFT_2020.getSchema(schema).validate(MAPPER.readTree(json)));
        }
        catch (IOException e) {
            return ValidationResult.error(e);
        }
    }

    @Override
    public ValidationResult validateXmlSubmissionDataSchema(byte[] xml, URI schemaUri) {
        if (this.config.isSkipSubmissionDataValidation()) {
            LOGGER.warn("Submission data validation is deactivated. This should be done only on secure test environments.");
            return ValidationResult.ok();
        }
        return this.xmlSchemaValidator.validate(xml, schemaUri);
    }

    @Override
    public ValidationResult validateJsonFormat(byte[] json) {
        try {
            MAPPER.readTree(json);
        }
        catch (IOException e) {
            return ValidationResult.error(e);
        }
        return ValidationResult.ok();
    }

    @Override
    public ValidationResult validateXmlFormat(byte[] xml) {
        try {
            XMLReader xmlReader = DefaultValidationService.getXmlReader();
            xmlReader.parse(new InputSource(new ByteArrayInputStream(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return ValidationResult.error(e);
        }
        return ValidationResult.ok();
    }

    @Override
    public ValidationResult validateCallback(String hmac, Long timestampInSec, String httpBody, String callbackSecret) {
        ZonedDateTime currentTimeFiveMinutesAgo;
        ZonedDateTime providedTimeInSeconds = ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestampInSec), ZoneId.systemDefault());
        if (providedTimeInSeconds.isBefore(currentTimeFiveMinutesAgo = ZonedDateTime.now().minusMinutes(5L))) {
            return ValidationResult.error(new ValidationException("Timestamp provided by callback is expired."));
        }
        String expectedHmac = this.messageDigestService.calculateHMAC(timestampInSec + "." + httpBody, callbackSecret);
        if (!hmac.equals(expectedHmac)) {
            return ValidationResult.error(new ValidationException("HMAC provided by callback does not match the expected result."));
        }
        return ValidationResult.ok();
    }

    @Override
    public ValidationResult validateData(byte[] decryptedData, String encryptedData, Metadata metadata, String eventAuthenticationTag) {
        ValidationResult dataSchemaValidation;
        String hashFromSender;
        ValidationResult hashValidation;
        String dataAuthTag = AuthenticationTags.getAuthTagFromJWT(encryptedData);
        if (!eventAuthenticationTag.equals(dataAuthTag)) {
            return ValidationResult.problem(new IncorrectDataAuthenticationTag());
        }
        Data data = metadata.getContentStructure().getData();
        if (this.validateIfDataIsNotTransferredAsAttachment(metadata, data) && (hashValidation = this.validateHashIntegrity(hashFromSender = data.getHash().getContent(), decryptedData)).hasError()) {
            return ValidationResult.problem(new DataHashMismatch());
        }
        if (data.getSubmissionSchema().getMimeType().equals((Object)MimeType.APPLICATION_JSON)) {
            ValidationResult jsonValidation = this.validateJsonFormat(decryptedData);
            if (jsonValidation.hasError()) {
                return ValidationResult.problem(new DataJsonSyntaxViolation());
            }
            dataSchemaValidation = this.validateJsonSubmissionDataSchema(decryptedData, data.getSubmissionSchema().getSchemaUri());
            if (dataSchemaValidation.hasError()) {
                return ValidationResult.problem(new DataSchemaViolation());
            }
        }
        if (data.getSubmissionSchema().getMimeType().equals((Object)MimeType.APPLICATION_XML)) {
            ValidationResult xmlValidation = this.validateXmlFormat(decryptedData);
            if (xmlValidation.hasError()) {
                return ValidationResult.problem(new DataXmlSyntaxViolation());
            }
            dataSchemaValidation = this.validateXmlSubmissionDataSchema(decryptedData, data.getSubmissionSchema().getSchemaUri());
            if (dataSchemaValidation.hasError()) {
                return ValidationResult.problem(new DataSchemaViolation());
            }
        }
        return ValidationResult.ok();
    }

    @Override
    public ValidationResult validateAttachments(List<AttachmentForValidation> attachmentsForValidation, AuthenticationTags authenticationTags) {
        Map<UUID, String> eventAuthTags = authenticationTags.getAttachments();
        ArrayList<Problem> validationProblems = new ArrayList<Problem>();
        for (AttachmentForValidation attachment : attachmentsForValidation) {
            if (attachment.hasFragmentedPayload()) {
                ValidationResult validationResult = this.validateFragmentedAttachment(attachment, eventAuthTags, validationProblems);
                if (!validationResult.hasError()) continue;
                return validationResult;
            }
            this.validateAttachment(attachment, eventAuthTags, validationProblems);
        }
        return validationProblems.isEmpty() ? ValidationResult.ok() : ValidationResult.problems(validationProblems);
    }

    private void validateAttachment(AttachmentForValidation attachment, Map<UUID, String> eventAuthTags, List<Problem> validationProblems) {
        ValidationResult validationResult;
        UUID attachmentId = attachment.getAttachmentId();
        String authTagFromEvent = eventAuthTags.get(attachmentId);
        if (!authTagFromEvent.equals(attachment.getAuthTag())) {
            validationProblems.add(new IncorrectAttachmentAuthenticationTag(attachmentId));
        }
        if ((validationResult = this.validateHashIntegrity(attachment.getHash(), attachment.getDecryptedData())).hasError()) {
            validationProblems.add(new AttachmentHashMismatch(attachment.getAttachmentId()));
        }
    }

    private ValidationResult validateFragmentedAttachment(AttachmentForValidation attachment, Map<UUID, String> eventAuthTags, List<Problem> validationProblems) {
        for (Fragment fragment : attachment.getFragments()) {
            String authTagFromEvent = eventAuthTags.get(fragment.getFragmentId());
            if (authTagFromEvent.equals(fragment.getAuthTag())) continue;
            validationProblems.add(new IncorrectAttachmentAuthenticationTag(fragment.getFragmentId()));
        }
        try (InputStream is = Files.newInputStream(attachment.getDataFile().toPath(), new OpenOption[0]);){
            ValidationResult validationResult = this.validateHashIntegrity(attachment.getHash(), is);
            if (validationResult.hasError()) {
                validationProblems.add(new AttachmentHashMismatch(attachment.getAttachmentId()));
            }
        }
        catch (IOException e) {
            return ValidationResult.error(e);
        }
        return ValidationResult.ok();
    }

    @Override
    public ValidationResult validateSubmissionMetadata(Metadata metadata, Submission submission, PublicDestination destination, AuthenticationTags eventAuthenticationTags) {
        return this.validateMetadata(metadata, submission.getEncryptedMetadata(), destination, submission.getPublicService(), submission.getAttachments(), eventAuthenticationTags);
    }

    @Override
    public ValidationResult validateReplyMetadata(Metadata metadata, Reply reply, PublicDestination destination, AuthenticationTags eventAuthenticationTags) {
        return this.validateMetadata(metadata, reply.getEncryptedMetadata(), destination, null, reply.getAttachments(), eventAuthenticationTags);
    }

    private ValidationResult validateMetadata(Metadata metadata, String encryptedMetadata, PublicDestination destination, PublicService serviceType, List<UUID> attachments, AuthenticationTags eventAuthenticationTags) {
        Optional<DestinationReplyChannels> matchingServiceReplyChannel;
        Optional<String> destinationService;
        String metadataAuthTag = AuthenticationTags.getAuthTagFromJWT(encryptedMetadata);
        if (!eventAuthenticationTags.getMetadata().equals(metadataAuthTag)) {
            return ValidationResult.problem(new IncorrectMetadataAuthenticationTag());
        }
        if (this.invalidJsonSyntax(metadata)) {
            return ValidationResult.problem(new MetadataJsonSyntaxViolation());
        }
        if (metadata.getContentStructure().getData() == null) {
            return ValidationResult.problem(new MissingData());
        }
        ValidationResult validationResult = this.validateMetadataSchema(metadata);
        if (validationResult.hasProblems()) {
            return validationResult;
        }
        if (destination.getPublicServices().isEmpty()) {
            return ValidationResult.problem(new UnsupportedDataSchema());
        }
        SubmissionSchema submissionSchema = metadata.getContentStructure().getData().getSubmissionSchema();
        boolean matchingSchemas = DefaultValidationService.matchingDestinationAndSubmissionSchema(destination, submissionSchema.getSchemaUri());
        if (!matchingSchemas) {
            return ValidationResult.problem(new UnsupportedDataSchema());
        }
        if (serviceType != null && (destinationService = destination.getPublicServices().stream().map(Service::getIdentifier).filter(identifier -> identifier.equals(serviceType.getIdentifier())).findFirst()).isEmpty()) {
            return ValidationResult.problem(new UnsupportedService());
        }
        ValidationResult attachmentValidation = this.checkAttachmentCount(attachments, metadata, eventAuthenticationTags);
        if (attachmentValidation.hasProblems()) {
            return attachmentValidation;
        }
        if (metadata.getReplyChannel() != null && serviceType != null && (matchingServiceReplyChannel = destination.getPublicServices().stream().filter(service -> service.getIdentifier().equals(serviceType.getIdentifier())).filter(service -> service.getSubmissionSchemas().stream().anyMatch(schema -> schema.equals(submissionSchema))).map(Service::getReplyChannels).filter(Objects::nonNull).filter(destinationReplyChannel -> destinationReplyChannel.allowsSubmissionReplyChannel(metadata.getReplyChannel())).findFirst()).isEmpty()) {
            return ValidationResult.problem(new UnsupportedReplyChannel());
        }
        return ValidationResult.ok();
    }

    private boolean validateIfDataIsNotTransferredAsAttachment(Metadata metadata, Data data) {
        boolean noAttachmentWithDataPurpose = metadata.getContentStructure().getAttachments().stream().map(ApiAttachment::getPurpose).noneMatch(purpose -> purpose.equals((Object)Purpose.DATA));
        return noAttachmentWithDataPurpose && !data.getHash().getContent().equals("cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
    }

    private static boolean matchingDestinationAndSubmissionSchema(PublicDestination destination, URI submissionDataSchemaUri) {
        return destination.getPublicServices().stream().flatMap(service -> service.getSubmissionSchemas().stream()).map(SubmissionSchema::getSchemaUri).anyMatch(submissionDataSchemaUri::equals);
    }

    private ValidationResult validate2020JsonSchema(String schema, JsonNode inputNode) {
        return this.returnValidationResult(SCHEMA_REGISTRY_DRAFT_2020.getSchema(schema).validate(inputNode));
    }

    private ValidationResult returnValidationResult(List<Error> errors) {
        if (errors.isEmpty()) {
            return ValidationResult.ok();
        }
        return ValidationResult.withErrorAndProblem(new ValidationException(this.errorsToSingleString(errors)), new MetadataSchemaViolation());
    }

    private ValidationResult validateKey(RSAKey publicKey, Date validationDate, KeyOperation purpose) throws JWKValidationException {
        if (this.config.isAllowInsecurePublicKey()) {
            return this.validateWithoutCertChain(publicKey, purpose);
        }
        return this.validateWithCertChain(publicKey, validationDate, purpose);
    }

    private ValidationResult validateWithoutCertChain(RSAKey publicKey, KeyOperation purpose) throws JWKValidationException {
        LOGGER.debug("Validating public key {} without XC5 certificate chain", (Object)publicKey.getKeyID());
        this.jwkValidator.validate(publicKey, purpose);
        return ValidationResult.ok();
    }

    private ValidationResult validateWithCertChain(RSAKey publicKey, Date validationDate, KeyOperation purpose) throws JWKValidationException {
        LOGGER.info("Validating public key with x5c certificate chain checks");
        if (publicKey.getParsedX509CertChain() == null) {
            throw new IllegalStateException("Public key with id '" + publicKey.getKeyID() + "' does not contain an x5c certificate chain");
        }
        if (validationDate == null) {
            this.jwkValidator.validate(publicKey, purpose);
        } else {
            this.jwkValidator.validate(publicKey, validationDate, purpose);
        }
        return ValidationResult.ok();
    }

    private String errorsToSingleString(List<Error> errors) {
        return errors.stream().map(e -> e.getInstanceLocation().toString() + ": " + e.getMessage()).collect(Collectors.joining("\n"));
    }

    private static XMLReader getXmlReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return saxParserFactory.newSAXParser().getXMLReader();
    }

    private boolean invalidJsonSyntax(Metadata metadata) {
        try {
            return metadata == null || this.validateJsonFormat(MAPPER.writeValueAsBytes((Object)metadata)).hasError();
        }
        catch (JsonProcessingException | NullPointerException e) {
            return true;
        }
    }

    private ValidationResult checkAttachmentCount(List<UUID> attachmentIds, Metadata metadata, AuthenticationTags authenticationTags) {
        block7: {
            block6: {
                List<ApiAttachment> metadataAttachments = metadata.getContentStructure().getAttachments();
                Map<UUID, String> attachmentAuthTags = authenticationTags.getAttachments();
                if ((Objects.isNull(attachmentIds) || attachmentIds.isEmpty()) && (Objects.isNull(attachmentAuthTags) || attachmentAuthTags.isEmpty())) {
                    return ValidationResult.ok();
                }
                ArrayList<UUID> actualIdsIncludingFragments = new ArrayList<UUID>();
                for (ApiAttachment metadataAttachment : metadataAttachments) {
                    List<UUID> fragments = metadataAttachment.getFragments();
                    if (metadataAttachment.hasFragments()) {
                        actualIdsIncludingFragments.addAll(fragments);
                        continue;
                    }
                    actualIdsIncludingFragments.add(metadataAttachment.getAttachmentId());
                }
                if (actualIdsIncludingFragments.size() != attachmentIds.size() || attachmentAuthTags.size() != attachmentIds.size() || !attachmentAuthTags.keySet().containsAll(attachmentIds) || !attachmentIds.stream().allMatch(id -> actualIdsIncludingFragments.stream().anyMatch(actualId -> actualId.equals(id)))) break block6;
                if (attachmentIds.stream().allMatch(attachmentAuthTags::containsKey)) break block7;
            }
            return ValidationResult.problem(new AttachmentsMismatch());
        }
        return ValidationResult.ok();
    }

    private JWKValidator createValidator(ApplicationConfig config, List<String> trustedRootCertificates) {
        if (config.isAllowInsecurePublicKey()) {
            return JWKValidator.withoutX5CValidation().withErrorLogLevel(LogLevel.WARN).build();
        }
        return JWKValidator.withRecommendedDefaults().withProxy(config.getHttpConfig().getProxyConfig().getHttpProxy()).withRootCertificatesAsPEM(trustedRootCertificates).build();
    }

    private static ObjectMapper createObjectMapper() {
        JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).build();
        return new ObjectMapper(jsonFactory).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd")).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    private ValidationResult validateSchemaAllowance(String schemaUri) {
        URI requestedSchemaUri = URI.create(schemaUri);
        if (!this.schemaProvider.isAllowedMetadataSchema(requestedSchemaUri)) {
            return ValidationResult.problem(new UnsupportedMetadataSchema(schemaUri));
        }
        return ValidationResult.ok();
    }

    private ValidationResult loadSchemaAndValidate(Metadata metadata) {
        URI requestedSchemaUri = URI.create(metadata.getSchema());
        String schema = this.loadMetadataSchemaWithFallback(requestedSchemaUri);
        return this.validateMetadataAgainstSchema(metadata, schema);
    }

    private String loadMetadataSchemaWithFallback(URI requestedSchemaUri) {
        try {
            return this.schemaProvider.loadMetadataSchema(requestedSchemaUri);
        }
        catch (Exception e) {
            URI fallbackSchema = this.config.getMetadataSchemaWriteVersion();
            LOGGER.info("Schema {} is not available, using fallback {}", (Object)requestedSchemaUri, (Object)fallbackSchema);
            return this.schemaProvider.loadMetadataSchema(fallbackSchema);
        }
    }

    private ValidationResult validateMetadataAgainstSchema(Metadata metadata, String schema) {
        try {
            String metadataJson = MAPPER.writeValueAsString((Object)metadata);
            JsonNode inputNode = MAPPER.readTree(metadataJson);
            return this.validate2020JsonSchema(schema, inputNode);
        }
        catch (JsonProcessingException | SchemaNotFoundException e) {
            return ValidationResult.withErrorAndProblem((Exception)e, new MetadataSchemaViolation());
        }
    }
}

