/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.utils;

import java.text.DecimalFormat;
import java.time.Duration;

public final class Formatter {
    private static final long BYTE = 1L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    private Formatter() {
    }

    static String formatMillis(long ms) {
        Duration dur = Duration.ofMillis(ms);
        if (dur.getSeconds() >= 60L) {
            return String.format("%02d:%02d min", dur.getSeconds() / 60L, dur.getSeconds() % 60L);
        }
        return String.format("%1d.%02d sec", dur.getSeconds(), dur.toMillis());
    }

    public static String toHumanReadableSizePrefix(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid file size: " + size);
        }
        if (size >= 0x40000000L) {
            return Formatter.formatSize(size, 0x40000000L, "GB");
        }
        if (size >= 0x100000L) {
            return Formatter.formatSize(size, 0x100000L, "MB");
        }
        if (size >= 1024L) {
            return Formatter.formatSize(size, 1024L, "KB");
        }
        return Formatter.formatSize(size, 1L, "bytes");
    }

    public static int toMegaBytes(long byteValue) {
        return (int)byteValue >> 10 >> 10;
    }

    private static String formatSize(long size, long divider, String unitName) {
        return DECIMAL_FORMAT.format((double)size / (double)divider) + " " + unitName;
    }
}

