/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import dev.fitko.fitconnect.api.domain.model.event.Event;
import dev.fitko.fitconnect.api.domain.model.event.EventIssuer;
import dev.fitko.fitconnect.api.domain.model.event.EventLogEntry;
import dev.fitko.fitconnect.api.domain.model.event.EventSubjectType;
import dev.fitko.fitconnect.api.domain.model.event.TypeAndUUID;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.exceptions.internal.EventLogException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public final class EventLogUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String AUTH_TAG_SPLIT_TOKEN = "\\.";

    private EventLogUtil() {
    }

    public static List<EventLogEntry> mapEventLogToEntries(List<SignedJWT> eventLog) {
        return eventLog.stream().map(EventLogUtil::eventToLogEntry).collect(Collectors.toList());
    }

    public static EventIssuer resolveIssuerType(String issuer) {
        if (issuer == null) {
            return EventIssuer.UNDEFINED;
        }
        return issuer.startsWith("http") ? EventIssuer.SUBMISSION_SERVICE : EventIssuer.DESTINATION;
    }

    public static Event getEventFromClaims(JWTClaimsSet claims) {
        Map events = (Map)claims.getClaim("events");
        Map.Entry eventEntry = events.entrySet().iterator().next();
        return Event.fromSchemaUri((String)eventEntry.getKey());
    }

    public static Event getEventFromJWT(SignedJWT event) {
        try {
            JWTClaimsSet claims = event.getJWTClaimsSet();
            Map events = (Map)claims.getClaim("events");
            Map.Entry eventEntry = events.entrySet().iterator().next();
            return Event.fromSchemaUri((String)eventEntry.getKey());
        }
        catch (ParseException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    public static UUID getDestinationId(String issuer) {
        EventIssuer issuerType = EventLogUtil.resolveIssuerType(issuer);
        if (issuerType.equals((Object)EventIssuer.SUBMISSION_SERVICE) || issuerType.equals((Object)EventIssuer.UNDEFINED)) {
            return null;
        }
        try {
            return UUID.fromString(issuer);
        }
        catch (IllegalArgumentException ex) {
            throw new EventLogException("Destination id '" + issuer + "' from issuer is no valid uuid");
        }
    }

    public static EventLogEntry eventToLogEntry(SignedJWT signedJWT) {
        JWTClaimsSet claimsSet = EventLogUtil.getClaimsSet(signedJWT);
        Map<String, Object> events = EventLogUtil.getClaimsAsMap(signedJWT);
        Map.Entry<String, Object> eventEntry = events.entrySet().iterator().next();
        Payload eventPayload = EventLogUtil.getEventPayload(eventEntry.getValue());
        return EventLogEntry.builder().event(Event.fromSchemaUri(eventEntry.getKey())).issuer(claimsSet.getIssuer()).issueTime(claimsSet.getIssueTime()).eventId(EventLogUtil.getEventId(claimsSet)).caseId(EventLogUtil.getTransactionClaim(claimsSet)).submissionId(EventLogUtil.getIdFromJWTSubject(claimsSet)).problems(eventPayload.getProblems()).build();
    }

    public static List<SignedJWT> getJWTSFromEvents(List<String> events) {
        return events.stream().map(EventLogUtil::getJWTFromEvent).collect(Collectors.toList());
    }

    public static List<SignedJWT> getJWTSFromEvents(List<String> events, EventSubjectType subjectFilter) {
        return events.stream().map(EventLogUtil::getJWTFromEvent).filter(EventLogUtil.eventSubjectEqualsType(subjectFilter)).collect(Collectors.toList());
    }

    public static UUID getIdFromJWTSubject(JWTClaimsSet claimsSet) {
        return TypeAndUUID.fromString(claimsSet.getSubject()).getUuid();
    }

    public static UUID getIdFromJWTSubject(SignedJWT signedJWT) {
        return TypeAndUUID.fromString(EventLogUtil.getClaimsSet(signedJWT).getSubject()).getUuid();
    }

    public static AuthenticationTags getAuthTags(SignedJWT jwt) {
        return EventLogUtil.getAuthTags(EventLogUtil.getClaimsSet(jwt));
    }

    public static AuthenticationTags getAuthTags(JWTClaimsSet claims) {
        try {
            Map eventsClaim = (Map)claims.getClaim("events");
            Map.Entry eventEntry = eventsClaim.entrySet().iterator().next();
            Map events = (Map)eventEntry.getValue();
            String authTags = MAPPER.writeValueAsString(events.get("authenticationTags"));
            return (AuthenticationTags)MAPPER.readValue(authTags, AuthenticationTags.class);
        }
        catch (JsonProcessingException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    public static List<SignedJWT> getFilteredJwtsFromEventLog(UUID subjectFilterId, Event event, List<String> eventLog) {
        return EventLogUtil.getJWTSFromEvents(eventLog).stream().filter(jwt -> EventLogUtil.getIdFromJWTSubject(jwt).equals(subjectFilterId)).filter(jwt -> EventLogUtil.getEventFromJWT(jwt).equals((Object)event)).collect(Collectors.toList());
    }

    public static Predicate<SignedJWT> eventSubjectEqualsId(UUID id) {
        return jwt -> {
            try {
                String subject = jwt.getJWTClaimsSet().getSubject();
                return TypeAndUUID.fromString(subject).getUuid().equals(id);
            }
            catch (ParseException e) {
                throw new EventLogException(e.getMessage(), e);
            }
        };
    }

    public static Predicate<SignedJWT> eventSubjectEqualsType(EventSubjectType subjectType) {
        return jwt -> {
            try {
                String subject = jwt.getJWTClaimsSet().getSubject();
                return TypeAndUUID.fromString(subject).getType().equals(subjectType.getName());
            }
            catch (ParseException e) {
                throw new EventLogException(e.getMessage(), e);
            }
        };
    }

    private static UUID getEventId(JWTClaimsSet claimsSet) {
        return UUID.fromString(claimsSet.getJWTID());
    }

    private static UUID getTransactionClaim(JWTClaimsSet claimsSet) {
        try {
            return TypeAndUUID.fromString(claimsSet.getStringClaim("txn")).getUuid();
        }
        catch (ParseException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    private static JWTClaimsSet getClaimsSet(SignedJWT signedJWT) {
        try {
            return signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    private static Map<String, Object> getClaimsAsMap(SignedJWT signedJWT) {
        try {
            return signedJWT.getJWTClaimsSet().getJSONObjectClaim("events");
        }
        catch (ParseException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    private static SignedJWT getJWTFromEvent(String event) {
        try {
            return SignedJWT.parse((String)event);
        }
        catch (ParseException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    private static Payload getEventPayload(Object payload) {
        try {
            return (Payload)MAPPER.readValue(MAPPER.writeValueAsString(payload), Payload.class);
        }
        catch (JsonProcessingException e) {
            throw new EventLogException(e.getMessage(), e);
        }
    }

    private static class Payload {
        @JsonProperty(value="authenticationTags")
        AuthenticationTags authenticationTags;
        @JsonProperty(value="problems")
        List<Problem> problems = new ArrayList<Problem>();

        @Generated
        public AuthenticationTags getAuthenticationTags() {
            return this.authenticationTags;
        }

        @Generated
        public List<Problem> getProblems() {
            return this.problems;
        }

        @Generated
        public void setAuthenticationTags(AuthenticationTags authenticationTags) {
            this.authenticationTags = authenticationTags;
        }

        @Generated
        public void setProblems(List<Problem> problems) {
            this.problems = problems;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payload)) {
                return false;
            }
            Payload other = (Payload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AuthenticationTags this$authenticationTags = this.getAuthenticationTags();
            AuthenticationTags other$authenticationTags = other.getAuthenticationTags();
            if (this$authenticationTags == null ? other$authenticationTags != null : !((Object)this$authenticationTags).equals(other$authenticationTags)) {
                return false;
            }
            List<Problem> this$problems = this.getProblems();
            List<Problem> other$problems = other.getProblems();
            return !(this$problems == null ? other$problems != null : !((Object)this$problems).equals(other$problems));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Payload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AuthenticationTags $authenticationTags = this.getAuthenticationTags();
            result = result * 59 + ($authenticationTags == null ? 43 : ((Object)$authenticationTags).hashCode());
            List<Problem> $problems = this.getProblems();
            result = result * 59 + ($problems == null ? 43 : ((Object)$problems).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EventLogUtil.Payload(authenticationTags=" + String.valueOf(this.getAuthenticationTags()) + ", problems=" + String.valueOf(this.getProblems()) + ")";
        }

        @Generated
        public Payload() {
        }
    }
}

