/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.submission;

import dev.fitko.fitconnect.api.domain.limits.submission.SubmissionLimits;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.submission.AnnounceSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.CreatedSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionsForPickup;
import dev.fitko.fitconnect.api.domain.model.submission.SubmitSubmission;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.auth.OAuthService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.submission.SubmissionService;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SubmissionApiService
implements SubmissionService {
    public static final String SUBMISSION_PATH = "/v2/submissions/%s";
    public static final String SUBMISSIONS_PATH = "/v2/submissions";
    public static final String DESTINATION_PATH = "/v2/destinations/%s";
    public static final String SUBMISSION_ATTACHMENT_PATH = "/v2/submissions/%s/attachments/%s";
    public static final String DESTINATION_ATTACHMENT_LIMITS_PATH = "/v2/destinations/%s/limits";
    public static final String CASE_ATTACHMENT_LIMITS_PATH = "/v2/cases/%s/limits";
    private final OAuthService authService;
    private final HttpClient httpClient;
    private final String baseUrl;

    public SubmissionApiService(OAuthService authService, HttpClient httpClient, String baseUrl) {
        this.authService = authService;
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    @Override
    public CreatedSubmission announceSubmission(AnnounceSubmission submission) throws RestApiException {
        try {
            return this.httpClient.post(this.baseUrl + SUBMISSIONS_PATH, this.buildHeaders("application/json"), submission, CreatedSubmission.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not announce submission for destination " + String.valueOf(submission.getDestinationId()), e);
        }
    }

    @Override
    public void uploadAttachment(UUID submissionId, UUID attachmentId, String encryptedAttachment) throws RestApiException {
        String url = String.format(this.baseUrl + SUBMISSION_ATTACHMENT_PATH, submissionId, attachmentId);
        try {
            this.httpClient.put(url, this.buildHeaders("application/jose"), encryptedAttachment, Void.class);
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not upload attachment", e);
        }
    }

    @Override
    public void uploadAttachmentStream(UUID submissionId, UUID attachmentId, InputStream encryptedAttachment) throws RestApiException {
        String url = String.format(this.baseUrl + SUBMISSION_ATTACHMENT_PATH, submissionId, attachmentId);
        try {
            this.httpClient.put(url, this.buildHeaders("application/jose"), encryptedAttachment, Void.class);
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not upload attachment", e);
        }
    }

    @Override
    public String getAttachment(UUID submissionId, UUID attachmentId) throws RestApiException {
        String url = String.format(this.baseUrl + SUBMISSION_ATTACHMENT_PATH, submissionId, attachmentId);
        try {
            return this.httpClient.get(url, this.buildHeaders("application/jose"), String.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get attachment " + String.valueOf(attachmentId), e);
        }
    }

    @Override
    public SubmissionLimits getDestinationAttachmentLimits(UUID destinationId) throws RestApiException {
        String url = String.format(this.baseUrl + DESTINATION_ATTACHMENT_LIMITS_PATH, destinationId);
        try {
            return this.httpClient.get(url, this.buildHeaders(), SubmissionLimits.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get attachment limits for destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public SubmissionLimits getCaseAttachmentLimits(UUID caseId) throws RestApiException {
        String url = String.format(this.baseUrl + CASE_ATTACHMENT_LIMITS_PATH, caseId);
        try {
            return this.httpClient.get(url, this.buildHeaders(), SubmissionLimits.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get attachment limits for case " + String.valueOf(caseId), e);
        }
    }

    @Override
    public PublicDestination getDestination(UUID destinationId) throws RestApiException {
        String url = String.format(this.baseUrl + DESTINATION_PATH, destinationId);
        try {
            return this.httpClient.get(url, this.buildHeaders(), PublicDestination.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get destination for id " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public Submission sendSubmission(SubmitSubmission submission) throws RestApiException {
        String url = String.format(this.baseUrl + SUBMISSION_PATH, submission.getSubmissionId());
        try {
            return this.httpClient.put(url, this.buildHeaders("application/json"), submission, Submission.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not send submission " + String.valueOf(submission.getSubmissionId()), e);
        }
    }

    @Override
    public SubmissionsForPickup pollAvailableSubmissionsForDestination(UUID destinationId, int offset, int limit) {
        String urlWithQueryParams = this.baseUrl + "/v2/submissions?destinationId=" + String.valueOf(destinationId) + "&limit=" + limit + "&offset=" + offset;
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), SubmissionsForPickup.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not poll for available submissions on destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public Submission getSubmission(UUID submissionId) throws RestApiException {
        try {
            return this.httpClient.get(String.format(this.baseUrl + SUBMISSION_PATH, submissionId), this.buildHeaders(), Submission.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Submission with id " + String.valueOf(submissionId) + " does not exist", e, e.getStatusCode());
        }
    }

    private Map<String, String> buildHeaders(String contentType) {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Content-Type", contentType));
    }

    private Map<String, String> buildHeaders() {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Accept", "application/json", "Accept-Charset", StandardCharsets.UTF_8.toString()));
    }
}

