/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.routing;

import dev.fitko.fitconnect.api.domain.model.route.AreaResult;
import dev.fitko.fitconnect.api.domain.model.route.RouteResult;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.routing.RoutingService;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class RoutingApiService
implements RoutingService {
    public static final String ROUTING_AREA_PATH = "/v2/areas";
    public static final String ROUTING_ROUTE_PATH = "/v2/routes";
    private final HttpClient httpClient;
    private final String baseUrl;

    public RoutingApiService(HttpClient httpClient, String baseUrl) {
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    @Override
    public AreaResult getAreas(List<String> searchExpressions, int offset, int limit) throws RestApiException {
        String url = this.baseUrl + ROUTING_AREA_PATH;
        ArrayList<CallSite> queryParameters = new ArrayList<CallSite>();
        searchExpressions.forEach(search -> queryParameters.add((CallSite)((Object)("areaSearchexpression=" + search))));
        queryParameters.add((CallSite)((Object)("offset=" + offset)));
        queryParameters.add((CallSite)((Object)("limit=" + limit)));
        String queryparameterString = String.join((CharSequence)"&", queryParameters);
        try {
            return this.httpClient.get(url + "?" + queryparameterString, this.getHttpHeaders("application/problem+json"), AreaResult.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Area query failed", e);
        }
    }

    @Override
    public RouteResult getRoutes(String leikaKey, String ars, String ags, String areaId, int offset, int limit) throws RestApiException {
        RoutingApiService.testIfSearchCriterionIsSet(ars, ags, areaId);
        String url = this.baseUrl + ROUTING_ROUTE_PATH;
        ArrayList<CallSite> queryParameters = new ArrayList<CallSite>();
        queryParameters.add((CallSite)((Object)("leikaKey=" + leikaKey)));
        if (ars != null) {
            queryParameters.add((CallSite)((Object)("ars=" + ars)));
        }
        if (ags != null) {
            queryParameters.add((CallSite)((Object)("ags=" + ags)));
        }
        if (areaId != null) {
            queryParameters.add((CallSite)((Object)("areaId=" + areaId)));
        }
        queryParameters.add((CallSite)((Object)("offset=" + offset)));
        queryParameters.add((CallSite)((Object)("limit=" + limit)));
        String queryparameterString = String.join((CharSequence)"&", queryParameters);
        try {
            return this.httpClient.get(url + "?" + queryparameterString, this.getHttpHeaders("application/json"), RouteResult.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Route query failed", e);
        }
    }

    private static void testIfSearchCriterionIsSet(String ars, String ags, String areaId) {
        List<String> areaSearchCriteria = Arrays.asList(ars, ags, areaId);
        if (areaSearchCriteria.stream().allMatch(RoutingApiService.CriterionEmpty())) {
            throw new RestApiException("At least one search criterion out of ags, ars or areaId must be set");
        }
        if (areaSearchCriteria.stream().filter(Predicate.not(RoutingApiService.CriterionEmpty())).count() > 1L) {
            throw new RestApiException("Only one of ars, ags or areaId must be specified.");
        }
    }

    private static Predicate<String> CriterionEmpty() {
        return criterion -> criterion == null || criterion.isEmpty();
    }

    private Map<String, String> getHttpHeaders(String mediaType) {
        return new HashMap<String, String>(Map.of("Accept", mediaType, "Accept-Charset", StandardCharsets.UTF_8.toString()));
    }
}

