/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.reply;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.reply.AcceptReply;
import dev.fitko.fitconnect.api.domain.model.reply.AnnounceReply;
import dev.fitko.fitconnect.api.domain.model.reply.CreatedReply;
import dev.fitko.fitconnect.api.domain.model.reply.RejectReply;
import dev.fitko.fitconnect.api.domain.model.reply.RepliesForPickup;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.domain.model.reply.SentReply;
import dev.fitko.fitconnect.api.domain.model.reply.SubmitReply;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.auth.OAuthService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.reply.ReplyService;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ReplyApiService
implements ReplyService {
    public static final String REPLIES_PATH = "/v2/replies";
    public static final String REPLY_PATH = "/v2/replies/%s";
    public static final String REPLY_ACCEPT_PATH = "/v2/replies/%s/accept";
    public static final String REPLY_REJECT_PATH = "/v2/replies/%s/reject";
    public static final String REPLY_ATTACHMENT_PATH = "/v2/replies/%s/attachments/%s";
    private final OAuthService authService;
    private final HttpClient httpClient;
    private final String baseUrl;

    public ReplyApiService(OAuthService authService, HttpClient httpClient, String baseUrl) {
        this.authService = authService;
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    @Override
    public CreatedReply announceReply(AnnounceReply announceReply) throws RestApiException {
        try {
            return this.httpClient.post(this.baseUrl + REPLIES_PATH, this.buildHeaders("application/json"), announceReply, CreatedReply.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not announce reply for case " + String.valueOf(announceReply.getCaseId()), e);
        }
    }

    @Override
    public SentReply submitReply(UUID replyId, SubmitReply submitReply) throws RestApiException {
        String url = String.format(this.baseUrl + REPLY_PATH, replyId);
        try {
            return this.httpClient.put(url, this.buildHeaders("application/json"), submitReply, SentReply.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not submit reply " + String.valueOf(replyId), e);
        }
    }

    @Override
    public Reply getReply(UUID replyId) throws RestApiException {
        try {
            return this.httpClient.get(String.format(this.baseUrl + REPLY_PATH, replyId), this.buildHeaders(), Reply.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Reply with id " + String.valueOf(replyId) + " does not exist", e, e.getStatusCode());
        }
    }

    @Override
    public RepliesForPickup getAvailableReplies(int limit, int offset) throws RestApiException {
        String urlWithQueryParams = this.baseUrl + "/v2/replies?limit=" + limit + "&offset=" + offset;
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), RepliesForPickup.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Polling for available replies failed", e);
        }
    }

    @Override
    public String acceptReply(UUID replyId, AcceptReply acceptReply) {
        String url = String.format(this.baseUrl + REPLY_ACCEPT_PATH, replyId);
        try {
            return this.httpClient.put(url, this.buildHeaders("application/json"), acceptReply, String.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Sending accept reply event failed", e);
        }
    }

    @Override
    public String rejectReply(UUID replyId, List<Problem> problems) {
        String url = String.format(this.baseUrl + REPLY_REJECT_PATH, replyId);
        try {
            return this.httpClient.put(url, this.buildHeaders("application/json"), new RejectReply(problems), String.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Sending reject reply event failed", e);
        }
    }

    @Override
    public void uploadAttachment(UUID replyId, UUID attachmentId, String encryptedAttachment) throws RestApiException {
        String url = String.format(this.baseUrl + REPLY_ATTACHMENT_PATH, replyId, attachmentId);
        try {
            this.httpClient.put(url, this.buildHeaders("application/jose"), encryptedAttachment, Void.class);
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not upload attachment for reply " + String.valueOf(replyId), e);
        }
    }

    @Override
    public String getAttachment(UUID replyId, UUID attachmentId) throws RestApiException {
        String url = String.format(this.baseUrl + REPLY_ATTACHMENT_PATH, replyId, attachmentId);
        try {
            return this.httpClient.get(url, this.buildHeaders("application/jose"), String.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get attachment " + String.valueOf(attachmentId) + " for reply " + String.valueOf(replyId), e);
        }
    }

    private Map<String, String> buildHeaders(String contentType) {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Content-Type", contentType));
    }

    private Map<String, String> buildHeaders() {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Accept", "application/json", "Accept-Charset", StandardCharsets.UTF_8.toString()));
    }
}

