/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.keys;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwk;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwkSet;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.internal.InvalidKeyException;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.auth.OAuthService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.keys.KeyService;
import dev.fitko.fitconnect.api.services.validation.ValidationService;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyApiService
implements KeyService {
    public static final String DESTINATIONS_KEY_PATH = "/v2/destinations/%s/keys/%s";
    public static final String WELL_KNOWN_KEYS_PATH = "/.well-known/jwks.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicKeyApiService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ApplicationConfig config;
    private final ValidationService validationService;
    private final HttpClient httpClient;
    private final OAuthService authService;

    public PublicKeyApiService(ApplicationConfig config, HttpClient httpClient, OAuthService authService, ValidationService validationService) {
        this.config = config;
        this.httpClient = httpClient;
        this.authService = authService;
        this.validationService = validationService;
    }

    public PublicKeyApiService(ApplicationConfig config, HttpClient httpClient, ValidationService validationService) {
        this(config, httpClient, null, validationService);
    }

    @Override
    public RSAKey getPublicEncryptionKey(PublicDestination destination) {
        String destinationUrl = this.config.getSubmissionBaseUrl() + DESTINATIONS_KEY_PATH;
        ApiJwk publicKey = this.performRequest(destinationUrl, ApiJwk.class, this.buildHeaders(true), destination.getDestinationId(), destination.getEncryptionKid());
        return this.getValidationEncryptionKey(publicKey);
    }

    @Override
    public RSAKey getDestinationPublicSignatureKey(UUID destinationId, String keyId, Date validationDate) {
        String destinationUrl = this.config.getSubmissionBaseUrl() + DESTINATIONS_KEY_PATH;
        ApiJwk signatureKey = this.performRequest(destinationUrl, ApiJwk.class, this.buildHeaders(true), destinationId, keyId);
        return this.getValidatedSignatureKey(signatureKey, validationDate);
    }

    @Override
    public RSAKey getSubmissionServicePublicSignatureKey(String keyId, Date validationDate) {
        String submissionServiceUrl = this.config.getSubmissionBaseUrl() + WELL_KNOWN_KEYS_PATH;
        ApiJwkSet wellKnownKeys = this.performRequest(submissionServiceUrl, ApiJwkSet.class, this.buildHeaders(false), new Object[0]);
        return this.getValidatedSignatureKey(keyId, validationDate, wellKnownKeys, submissionServiceUrl);
    }

    @Override
    public RSAKey getPublicSignatureWellKnownKey(String keyId, String baseUrl, Date validationDate) {
        String signatureKeyUrl = baseUrl + WELL_KNOWN_KEYS_PATH;
        ApiJwkSet wellKnownKeys = this.performRequest(signatureKeyUrl, ApiJwkSet.class, this.buildHeaders(false), new Object[0]);
        return this.getValidatedSignatureKey(keyId, validationDate, wellKnownKeys, signatureKeyUrl);
    }

    private RSAKey getValidatedSignatureKey(String keyId, Date validationDate, ApiJwkSet wellKnownKeys, String requestUrl) {
        RSAKey key = this.getRsaKey(keyId, wellKnownKeys, requestUrl);
        ValidationResult result = this.validationService.validatePublicKey(key, validationDate, KeyOperation.VERIFY);
        this.validateResult(result, "Public signature key is not valid");
        return key;
    }

    private RSAKey getValidationEncryptionKey(ApiJwk publicKey) {
        RSAKey rsaKey = this.toRSAKey(publicKey);
        ValidationResult result = this.validationService.validatePublicKey(rsaKey, KeyOperation.WRAP_KEY);
        this.validateResult(result, "Invalid public encryption key");
        return rsaKey;
    }

    private RSAKey getValidatedSignatureKey(ApiJwk publicKey, Date validationDate) {
        RSAKey rsaKey = this.toRSAKey(publicKey);
        ValidationResult result = this.validationService.validatePublicKey(rsaKey, validationDate, KeyOperation.VERIFY);
        this.validateResult(result, "Public signature key is not valid");
        return rsaKey;
    }

    private RSAKey getRsaKey(String keyId, ApiJwkSet wellKnownKeys, String requestUrl) {
        Optional<RSAKey> signatureKey = this.filterKeysById(keyId, wellKnownKeys.getKeys());
        return signatureKey.orElseThrow(() -> new InvalidKeyException("Key with id " + keyId + " could not be found at url " + requestUrl));
    }

    private Optional<RSAKey> filterKeysById(String keyId, List<ApiJwk> keys) {
        return keys.stream().filter(key -> key.getKid().equals(keyId)).map(this::toRSAKey).findFirst();
    }

    private void validateResult(ValidationResult validationResult, String message) {
        if (validationResult.hasError()) {
            if (this.config.isAllowInsecurePublicKey()) {
                LOGGER.warn(message, (Throwable)validationResult.getError());
            } else {
                throw new InvalidKeyException(message, validationResult.getError());
            }
        }
    }

    private RSAKey toRSAKey(ApiJwk jwk) {
        try {
            return RSAKey.parse((String)MAPPER.writeValueAsString((Object)jwk));
        }
        catch (JsonProcessingException | ParseException e) {
            throw new InvalidKeyException("Key could not be parsed", e);
        }
    }

    private <T> T performRequest(String url, Class<T> responseType, Map<String, String> headers, Object ... params) {
        try {
            return this.httpClient.get(String.format(url, params), headers, responseType).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Request failed", e);
        }
    }

    private Map<String, String> buildHeaders(boolean withAuthorization) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Accept-Charset", StandardCharsets.UTF_8.toString());
        if (withAuthorization) {
            headers.put("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken());
        }
        return headers;
    }
}

