/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ProcessRunner {
    public static Result runCommand(List<String> command) {
        if (command == null || command.isEmpty()) {
            return new Result(-1, "", "Command list must not be null or empty");
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(false);
        try {
            Process process = builder.start();
            String output = ProcessRunner.getOutputFromStream(process.getInputStream());
            String error = ProcessRunner.getOutputFromStream(process.getErrorStream());
            int exitCode = process.waitFor();
            return new Result(exitCode, output, error);
        }
        catch (IOException | IllegalArgumentException | InterruptedException e) {
            return new Result(-1, "", e.getMessage());
        }
    }

    private static String getOutputFromStream(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static final class Result {
        public final int exitCode;
        public final String output;
        public final String error;

        @Generated
        public Result(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.output = output;
            this.error = error;
        }

        @Generated
        public int getExitCode() {
            return this.exitCode;
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public String getError() {
            return this.error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (this.getExitCode() != other.getExitCode()) {
                return false;
            }
            String this$output = this.getOutput();
            String other$output = other.getOutput();
            if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExitCode();
            String $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProcessRunner.Result(exitCode=" + this.getExitCode() + ", output=" + this.getOutput() + ", error=" + this.getError() + ")";
        }
    }
}

