/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.http.ssl;

import dev.fitko.fitconnect.api.config.ZBPCertConfig;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectInitialisationException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.internal.platform.Platform;

public class SSLContextBuilder {
    public static HttpClientSSLContext build(ZBPCertConfig config) {
        try {
            TrustManager[] trustManagers = SSLContextBuilder.createTrustManager(config);
            KeyManager[] keyManagers = SSLContextBuilder.createIdentityStore(config);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new HttpClientSSLContext(sslSocketFactory, (X509TrustManager)trustManagers[0]);
        }
        catch (Exception e) {
            throw new FitConnectInitialisationException(e.getMessage(), e);
        }
    }

    private static TrustManager[] createTrustManager(ZBPCertConfig config) throws Exception {
        if (config.getZbpServerCertificate().isEmpty()) {
            return new TrustManager[]{Platform.get().platformTrustManager()};
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream serverCertStream = new ByteArrayInputStream(config.getZbpServerCertificate().get().getBytes(StandardCharsets.UTF_8));
        Certificate trustedCertificate = certificateFactory.generateCertificate(serverCertStream);
        KeyStore trustStore = SSLContextBuilder.createEmptyKeyStore();
        trustStore.setCertificateEntry("server-certificate", trustedCertificate);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private static KeyManager[] createIdentityStore(ZBPCertConfig config) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] privateKeyAsBytes = config.getClientPrivateKey().toRSAPrivateKey().getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyAsBytes);
        ByteArrayInputStream clientCertStream = new ByteArrayInputStream(config.getClientCertificate().getBytes());
        Certificate certificateChain = certificateFactory.generateCertificate(clientCertStream);
        KeyStore identityStore = SSLContextBuilder.createEmptyKeyStore();
        identityStore.setKeyEntry("client", keyFactory.generatePrivate(keySpec), null, new Certificate[]{certificateChain});
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(identityStore, null);
        return keyManagerFactory.getKeyManagers();
    }

    private static KeyStore createEmptyKeyStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        return keyStore;
    }

    @Generated
    private SSLContextBuilder() {
    }

    public static class HttpClientSSLContext {
        SSLSocketFactory sslSocketFactory;
        X509TrustManager trustManager;

        @Generated
        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        @Generated
        public X509TrustManager getTrustManager() {
            return this.trustManager;
        }

        @Generated
        public HttpClientSSLContext(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
        }
    }
}

