/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.http.retrylogic;

import dev.fitko.fitconnect.core.utils.Preconditions;
import java.util.Random;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackoff {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExponentialBackoff.class);
    private final int maxRetries;
    private final int initialDelay;
    private int retriesLeft;
    private int delay;

    public ExponentialBackoff(int maxRetries, int initialDelayInMs) {
        Preconditions.checkArgumentAndThrow(maxRetries <= 0, "maxRetries must be > 0");
        Preconditions.checkArgumentAndThrow(initialDelayInMs <= 0, "initialDelayInMs must be > 0");
        this.maxRetries = maxRetries;
        this.initialDelay = initialDelayInMs;
        this.retriesLeft = maxRetries;
        this.delay = initialDelayInMs;
    }

    public ExponentialBackoff(int maxRetries) {
        this(maxRetries, new Random().nextInt(1000));
    }

    public boolean retriesAvailable() {
        return this.retriesLeft > 0;
    }

    public void backoffWithDelay() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            LOGGER.error("Waiting for next request attempt failed", (Throwable)e);
        }
        if (this.retriesAvailable()) {
            --this.retriesLeft;
            this.delay *= 2;
        }
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public int getInitialDelay() {
        return this.initialDelay;
    }

    @Generated
    public int getRetriesLeft() {
        return this.retriesLeft;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }
}

