/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.http.interceptors;

import dev.fitko.fitconnect.api.config.http.RetryConfig;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.core.http.retrylogic.ExponentialBackoff;
import dev.fitko.fitconnect.core.http.retrylogic.RandomValue;
import java.io.IOException;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryInterceptor.class);
    public static final String EXCEPTION_MSG = "Request failed with exception, retrying with a delay of {}ms, remaining attempts {}";
    public static final String UNSUCCESSFUL_MSG = "Request failed with status {}, retrying with a delay of {}ms, remaining attempts {}";
    private final RetryConfig retryConfig;

    public RetryInterceptor(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public Response intercept(Interceptor.Chain chain) {
        PossibleResponse possibleResponse = this.attemptNextResponse(chain);
        if (possibleResponse.isSuccessful()) {
            return possibleResponse.getActualResponse();
        }
        ExponentialBackoff backoffHandler = this.getBackoffHandler();
        while (this.shouldRetry(possibleResponse, backoffHandler)) {
            backoffHandler.backoffWithDelay();
            this.closePreviousResponse(possibleResponse);
            possibleResponse = this.attemptNextResponse(chain);
        }
        if (!backoffHandler.retriesAvailable() && possibleResponse.isNotSuccessful()) {
            LOGGER.error("*** Retries consumed after {} attempts ***", (Object)backoffHandler.getMaxRetries());
        }
        if (possibleResponse.hasException()) {
            Exception exception = possibleResponse.getException();
            throw new RestApiException(exception.getMessage(), exception);
        }
        if (possibleResponse.isSuccessful()) {
            LOGGER.info("*** Retry was successful ! ***");
        }
        return possibleResponse.getActualResponse();
    }

    private void closePreviousResponse(PossibleResponse response) {
        if (response.hasResponse()) {
            response.getActualResponse().close();
        }
    }

    private PossibleResponse attemptNextResponse(Interceptor.Chain chain) {
        try {
            Request request = chain.request();
            return PossibleResponse.withResponse(chain.proceed(request));
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return PossibleResponse.withException(e);
        }
    }

    private boolean shouldRetry(PossibleResponse response, ExponentialBackoff backoffHandler) {
        long backoffDelay = backoffHandler.getDelay();
        int leftRetries = backoffHandler.getRetriesLeft() - 1;
        boolean retriesAvailable = backoffHandler.retriesAvailable();
        if (response.hasException() && retriesAvailable) {
            LOGGER.warn(EXCEPTION_MSG, (Object)backoffDelay, (Object)leftRetries);
            return true;
        }
        if (response.hasResponse() && this.statusCodeRetryable(response) && retriesAvailable) {
            LOGGER.warn(UNSUCCESSFUL_MSG, new Object[]{response.getActualResponse().code(), backoffDelay, leftRetries});
            return true;
        }
        return false;
    }

    private boolean statusCodeRetryable(PossibleResponse response) {
        return this.retryConfig.getRetryableStatusCodes().contains(response.getActualResponse().code());
    }

    private ExponentialBackoff getBackoffHandler() {
        int min = Math.round((float)this.retryConfig.getInitialDelayInMs() * 0.7f);
        int max = Math.round((float)this.retryConfig.getInitialDelayInMs() * 1.3f);
        int distributedStartDelay = RandomValue.randomIntInRange(min, max);
        return new ExponentialBackoff(this.retryConfig.getMaxRetryCount(), distributedStartDelay);
    }

    private static final class PossibleResponse {
        private final Response actualResponse;
        private final Exception exception;

        static PossibleResponse withResponse(Response response) {
            return new PossibleResponse(response, null);
        }

        static PossibleResponse withException(Exception exception) {
            return new PossibleResponse(null, exception);
        }

        boolean isSuccessful() {
            return this.hasResponse() && this.actualResponse.isSuccessful();
        }

        boolean isNotSuccessful() {
            return !this.isSuccessful() || this.hasException();
        }

        boolean hasException() {
            return this.exception != null && this.actualResponse == null;
        }

        boolean hasResponse() {
            return this.actualResponse != null;
        }

        @Generated
        public Response getActualResponse() {
            return this.actualResponse;
        }

        @Generated
        public Exception getException() {
            return this.exception;
        }

        @Generated
        public PossibleResponse(Response actualResponse, Exception exception) {
            this.actualResponse = actualResponse;
            this.exception = exception;
        }
    }
}

