/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.http.interceptors;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRequestInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiRequestInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long start = System.nanoTime();
        Response response = chain.proceed(request);
        long end = System.nanoTime();
        LOGGER.info("Received response {} for {} on {} in {}ms", new Object[]{response.code(), request.method(), response.request().url(), String.format("%.1f", (double)(end - start) / 1000000.0)});
        return response;
    }
}

