/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.fitko.fitconnect.api.config.ZBPCertConfig;
import dev.fitko.fitconnect.api.config.defaults.ZBPEnvironment;
import dev.fitko.fitconnect.api.config.http.HttpConfig;
import dev.fitko.fitconnect.api.config.http.ProxyAuth;
import dev.fitko.fitconnect.api.config.http.ProxyConfig;
import dev.fitko.fitconnect.api.config.http.Timeouts;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.http.HttpResponse;
import dev.fitko.fitconnect.client.util.MetadataDeserializationHelper;
import dev.fitko.fitconnect.core.http.ssl.SSLContextBuilder;
import dev.fitko.fitconnect.core.utils.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule());
    private final OkHttpClient httpClient;

    public DefaultHttpClient() {
        this(new HttpConfig(), Collections.emptyList());
    }

    public DefaultHttpClient(HttpConfig httpConfig, List<Interceptor> interceptors) {
        this(httpConfig, interceptors, null, null);
    }

    public DefaultHttpClient(HttpConfig httpConfig, List<Interceptor> interceptors, ZBPCertConfig zbpCertConfig, ZBPEnvironment zbpEnvironment) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.setInterceptors(interceptors, builder);
        this.setTimeouts(httpConfig.getTimeouts(), builder);
        this.setProxy(httpConfig.getProxyConfig(), builder);
        this.setSSLContext(zbpCertConfig, zbpEnvironment, builder);
        this.httpClient = builder.build();
    }

    private void setSSLContext(ZBPCertConfig zbpCertConfig, ZBPEnvironment zbpEnvironment, OkHttpClient.Builder builder) {
        if (zbpCertConfig != null && zbpEnvironment != null && !zbpEnvironment.isSendCertAsCookie()) {
            this.addSSLContext(zbpCertConfig, builder);
        }
    }

    private void setProxy(ProxyConfig proxyConfig, OkHttpClient.Builder builder) {
        if (!proxyConfig.isProxySet()) {
            LOGGER.info("Creating HttpClient without proxy configuration.");
            return;
        }
        Proxy proxy = proxyConfig.getHttpProxy();
        LOGGER.info("Creating HttpClient with proxy configuration: {}", (Object)proxy);
        builder.proxy(proxy);
        if (proxyConfig.hasBasicAuthentication()) {
            LOGGER.info("Creating proxy with basic authentication");
            Authenticator proxyAuthenticator = this.getProxyAuthenticator(proxyConfig.getBasicAuth());
            builder.proxyAuthenticator(proxyAuthenticator);
        }
    }

    private Authenticator getProxyAuthenticator(ProxyAuth auth) {
        return (route, response) -> {
            String credential = Credentials.basic((String)auth.getUsername(), (String)auth.getPassword());
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        };
    }

    private void setInterceptors(List<Interceptor> interceptors, OkHttpClient.Builder builder) {
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
    }

    private void setTimeouts(Timeouts timeouts, OkHttpClient.Builder builder) {
        builder.callTimeout(timeouts.getCallTimeoutInSeconds());
        builder.readTimeout(timeouts.getReadTimeoutInSeconds());
        builder.writeTimeout(timeouts.getWriteTimeoutInSeconds());
        builder.connectTimeout(timeouts.getConnectionTimeoutInSeconds());
    }

    @Override
    public <R> HttpResponse<R> get(String url, Map<String, String> headers, Class<R> responseType) {
        HttpResponse<R> httpResponse;
        block9: {
            Request request = new Request.Builder().url(url).get().headers(Headers.of(headers)).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                httpResponse = this.evaluateStatusAndRespond(response, responseType);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RestApiException restApiException) {
                    throw restApiException;
                }
                catch (Exception exception) {
                    throw new RestApiException("HTTP GET call to '" + url + "' failed.", exception);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    @Override
    public <P, R> HttpResponse<R> post(String url, Map<String, String> headers, P httpPayload, Class<R> responseType) {
        HttpResponse<R> httpResponse;
        block9: {
            RequestBody requestBody = this.createRequestBody(headers, httpPayload);
            Request request = new Request.Builder().url(url).post(requestBody).headers(Headers.of(headers)).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                httpResponse = this.evaluateStatusAndRespond(response, responseType);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RestApiException restApiException) {
                    throw restApiException;
                }
                catch (Exception exception) {
                    throw new RestApiException("HTTP POST call to '" + url + "' failed.", exception);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    @Override
    public <P, R> HttpResponse<R> put(String url, Map<String, String> headers, P httpPayload, Class<R> responseType) {
        HttpResponse<R> httpResponse;
        block9: {
            RequestBody requestBody = this.createRequestBody(headers, httpPayload);
            Request request = new Request.Builder().url(url).put(requestBody).headers(Headers.of(headers)).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                httpResponse = this.evaluateStatusAndRespond(response, responseType);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RestApiException restApiException) {
                    throw restApiException;
                }
                catch (Exception exception) {
                    throw new RestApiException("HTTP PUT call to '" + url + "' failed.", exception);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    @Override
    public <P, R> HttpResponse<R> patch(String url, Map<String, String> headers, P httpPayload, Class<R> responseType) {
        HttpResponse<R> httpResponse;
        block8: {
            RequestBody requestBody = this.createRequestBody(headers, httpPayload);
            Request request = new Request.Builder().url(url).patch(requestBody).headers(Headers.of(headers)).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                httpResponse = this.evaluateStatusAndRespond(response, responseType);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new RestApiException("HTTP PATCH call to '" + url + "' failed.", exception);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    @Override
    public HttpResponse<Void> delete(String url, Map<String, String> headers) {
        HttpResponse<Void> httpResponse;
        block8: {
            Request request = new Request.Builder().url(url).delete().headers(Headers.of(headers)).build();
            Response response = this.httpClient.newCall(request).execute();
            try {
                httpResponse = this.evaluateStatusAndRespond(response, Void.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new RestApiException("HTTP DELETE call to '" + url + "' failed.", exception);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    <T> RequestBody createRequestBody(Map<String, String> headers, T httpPayload) throws JsonProcessingException {
        if (httpPayload instanceof MultipartBody) {
            return (MultipartBody)httpPayload;
        }
        if (httpPayload instanceof InputStream) {
            return DefaultHttpClient.getRequestBodyWithStreamPayload(headers, (InputStream)httpPayload);
        }
        return RequestBody.create((byte[])DefaultHttpClient.buildPayloadBody(httpPayload), (MediaType)DefaultHttpClient.getContentType(headers));
    }

    <R> HttpResponse<R> evaluateStatusAndRespond(Response response, Class<R> responseType) throws IOException {
        if (!response.isSuccessful()) {
            String message = response.body() != null ? response.body().string() : "HTTP call failed.";
            throw new RestApiException(message, response.code());
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new RestApiException("Response body is null.", response.code());
        }
        if (responseType.equals(Void.class)) {
            return new HttpResponse<Object>(response.code(), null);
        }
        if (responseType.equals(String.class)) {
            return new HttpResponse<String>(response.code(), responseBody.string());
        }
        if (responseType.equals(InputStream.class)) {
            ByteArrayInputStream buffer = new ByteArrayInputStream(response.body().byteStream().readAllBytes());
            return new HttpResponse<ByteArrayInputStream>(response.code(), buffer);
        }
        if (responseType.equals(Metadata.class)) {
            return new HttpResponse<Metadata>(response.code(), MetadataDeserializationHelper.deserializeMetadata(MAPPER, responseBody.string().getBytes(StandardCharsets.UTF_8)));
        }
        return new HttpResponse<Object>(response.code(), MAPPER.readValue(responseBody.string(), responseType));
    }

    private void addSSLContext(ZBPCertConfig config, OkHttpClient.Builder clientBuilder) {
        Preconditions.checkArgumentAndThrow(!config.hasValidConfiguration(), "Required ZBP certificates are not set");
        SSLContextBuilder.HttpClientSSLContext sslContext = SSLContextBuilder.build(config);
        clientBuilder.sslSocketFactory(sslContext.getSslSocketFactory(), sslContext.getTrustManager());
    }

    private static RequestBody getRequestBodyWithStreamPayload(final Map<String, String> headers, final InputStream httpPayload) {
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)((String)headers.get("Content-Type")));
            }

            public void writeTo(BufferedSink sink) throws IOException {
                httpPayload.transferTo(sink.outputStream());
            }
        };
    }

    private static MediaType getContentType(Map<String, String> headers) {
        if (headers.containsKey("Content-Type")) {
            return MediaType.parse((String)headers.get("Content-Type"));
        }
        return MediaType.get((String)"application/json");
    }

    private static <T> byte[] buildPayloadBody(T httpPayload) throws JsonProcessingException {
        if (httpPayload instanceof String) {
            return ((String)httpPayload).getBytes(StandardCharsets.UTF_8);
        }
        return MAPPER.writeValueAsBytes(httpPayload);
    }
}

