/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.destination;

import dev.fitko.fitconnect.api.domain.limits.destination.DestinationLimits;
import dev.fitko.fitconnect.api.domain.limits.destination.LimitChangeRequest;
import dev.fitko.fitconnect.api.domain.model.destination.CreateDestination;
import dev.fitko.fitconnect.api.domain.model.destination.Destination;
import dev.fitko.fitconnect.api.domain.model.destination.Destinations;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwk;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwks;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.auth.OAuthService;
import dev.fitko.fitconnect.api.services.destination.DestinationService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DestinationApiService
implements DestinationService {
    private static final String DESTINATIONS_PATH = "/v2/destinations";
    private static final String DESTINATION_PATH = "/v2/destinations/%s";
    private static final String DESTINATION_KEYS_PATH = "/v2/destinations/%s/keys";
    private static final String DESTINATION_KEY_PATH = "/v2/destinations/%s/keys/%s";
    private static final String DESTINATION_ATTACHMENT_LIMITS_PATH = "/v2/destinations/%s/limits";
    private final OAuthService authService;
    private final HttpClient httpClient;
    private final String baseUrl;

    public DestinationApiService(OAuthService authService, HttpClient httpClient, String baseUrl) {
        this.authService = authService;
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    @Override
    public Destination getDestination(UUID destinationId) throws RestApiException {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_PATH, destinationId);
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), Destination.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public Destination createDestination(CreateDestination destination) {
        String url = this.baseUrl + DESTINATIONS_PATH;
        try {
            return this.httpClient.post(url, this.buildHeaders("application/json"), destination, Destination.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not create new destination", e);
        }
    }

    @Override
    public Destination updateDestination(Destination destination) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_PATH, destination.getDestinationId());
        try {
            return this.httpClient.put(urlWithQueryParams, this.buildHeaders("application/json"), destination, Destination.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not update destination " + String.valueOf(destination.getDestinationId()), e);
        }
    }

    @Override
    public void deleteDestination(UUID destinationId) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_PATH, destinationId);
        try {
            this.httpClient.delete(urlWithQueryParams, this.buildHeaders("application/json"));
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not delete destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public Destinations listDestinations(int offset, int limit) {
        String urlWithQueryParams = this.baseUrl + "/v2/destinations?limit=" + limit + "&offset=" + offset;
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), Destinations.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not poll for available destinations", e);
        }
    }

    @Override
    public DestinationLimits getAttachmentLimits(UUID destinationId) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_ATTACHMENT_LIMITS_PATH, destinationId);
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), DestinationLimits.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get attachment limits for destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public DestinationLimits requestLimitChange(UUID destinationId, LimitChangeRequest limitChangeRequest) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_ATTACHMENT_LIMITS_PATH, destinationId);
        try {
            DestinationLimits destinationLimits = DestinationLimits.withChangeRequest(limitChangeRequest);
            return this.httpClient.patch(urlWithQueryParams, this.buildHeaders("application/json"), destinationLimits, DestinationLimits.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not send limit change request for destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public ApiJwks listKeys(UUID destinationId, int offset, int limit) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_KEYS_PATH, destinationId) + "?limit=" + limit + "&offset=" + offset;
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), ApiJwks.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not list keys for destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public ApiJwk getKey(UUID destinationId, String keyId) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_KEY_PATH, destinationId, keyId);
        try {
            return this.httpClient.get(urlWithQueryParams, this.buildHeaders(), ApiJwk.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not get key " + keyId + " for destination " + String.valueOf(destinationId), e);
        }
    }

    @Override
    public void addKey(UUID destinationId, ApiJwk apiJwk) {
        String urlWithQueryParams = String.format(this.baseUrl + DESTINATION_KEYS_PATH, destinationId);
        try {
            this.httpClient.post(urlWithQueryParams, this.buildHeaders("application/json"), apiJwk, Void.class);
        }
        catch (RestApiException e) {
            throw new RestApiException("Could not add key " + apiJwk.getKid() + " to destination " + String.valueOf(destinationId), e);
        }
    }

    private Map<String, String> buildHeaders(String contentType) {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Content-Type", contentType));
    }

    private Map<String, String> buildHeaders() {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Accept", "application/json", "Accept-Charset", StandardCharsets.UTF_8.toString()));
    }
}

