/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.crypto.utils;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64;
import dev.fitko.fitconnect.api.exceptions.internal.KeyGenerationException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class KeyGenerator {
    private KeyGenerator() {
    }

    public static KeyPair buildRSAKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(keySize);
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidParameterException | NoSuchAlgorithmException e) {
            throw new KeyGenerationException(e.getMessage(), e);
        }
    }

    public static JWK buildJWK(KeyPair keyPair, String keyId, KeyOperation keyOperation, Algorithm algorithm, List<Base64> x5cCertificateChain) {
        RSAKey.Builder keyBuilder = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).keyID(keyId).keyOperations(Set.of(keyOperation)).algorithm(algorithm);
        if (!x5cCertificateChain.isEmpty()) {
            keyBuilder.x509CertChain(x5cCertificateChain);
        }
        return keyBuilder.build();
    }

    public static JWK buildJWK(KeyPair keyPair, String keyId, KeyOperation keyOperation, Algorithm algorithm) {
        return KeyGenerator.buildJWK(keyPair, keyId, keyOperation, algorithm, Collections.emptyList());
    }
}

