/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.crypto.utils;

import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertUtils;
import dev.fitko.fitconnect.api.exceptions.internal.CertificateEncodingException;
import dev.fitko.fitconnect.api.exceptions.internal.KeyGenerationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class CertUtils {
    public static final String PEM_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    public static final String PEM_END_MARKER = "-----END CERTIFICATE-----";

    public static X509Certificate generateX509Certificate(KeyPair keyPair, Duration validityFromNow) throws KeyGenerationException {
        Instant now = Instant.now();
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(validityFromNow));
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA512withRSA").build(keyPair.getPrivate());
            X500Name x500Name = new X500Name("CN=FIT-Connect");
            X500Name x500Subject = new X500Name("C=TestCert");
            BigInteger serialNr = BigInteger.valueOf(now.toEpochMilli());
            JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, serialNr, notBefore, notAfter, x500Subject, keyPair.getPublic());
            return new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new KeyGenerationException(e.getMessage(), e);
        }
    }

    public static String convertToBase64EncodedX509Certificate(byte[] certificateData) throws CertificateEncodingException {
        String string;
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(certificateData);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(certificateInputStream);
            string = Base64.encode((byte[])x509Certificate.getEncoded()).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)certificateInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException e) {
                throw new CertificateEncodingException("Failed to encode certificate", e);
            }
        }
        ((InputStream)certificateInputStream).close();
        return string;
    }

    public static String getSubjectCNFromCertificate(String pemCertificate) {
        try {
            X509Certificate certificate = X509CertUtils.parseWithException((String)pemCertificate);
            X500Principal principal = certificate.getSubjectX500Principal();
            X500Name x500Name = new X500Name(principal.getName());
            RDN x500NameRDN = x500Name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString((ASN1Encodable)x500NameRDN.getFirst().getValue());
        }
        catch (CertificateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String removeMarker(String clientCertificate) {
        return clientCertificate.replaceAll(PEM_BEGIN_MARKER, "").replaceAll(PEM_END_MARKER, "").replaceAll("\n", "").replaceAll("\r", "");
    }

    @Generated
    private CertUtils() {
    }
}

