/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.crypto;

import dev.fitko.fitconnect.api.exceptions.internal.EncryptionException;
import dev.fitko.fitconnect.api.services.crypto.MessageDigestService;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HashService
implements MessageDigestService {
    @Override
    public byte[] createHash(byte[] data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            return messageDigest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] createHash(InputStream inputStream) {
        try {
            int read;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, read);
            }
            return messageDigest.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verify(byte[] originalHash, byte[] data) {
        byte[] newHash = this.createHash(data);
        return this.compareHashes(originalHash, newHash);
    }

    @Override
    public boolean verify(byte[] originalHash, InputStream data) {
        byte[] newHash = this.createHash(data);
        return this.compareHashes(originalHash, newHash);
    }

    @Override
    public String toHexString(byte[] hash) {
        StringBuilder hexStringBuffer = new StringBuilder();
        for (byte b : hash) {
            hexStringBuffer.append(this.byteToHex(b));
        }
        return hexStringBuffer.toString();
    }

    @Override
    public byte[] fromHexString(String hexString) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = this.hexToByte(hexString.substring(i, i + 2));
        }
        return bytes;
    }

    @Override
    public String calculateHMAC(String data, String key) {
        try {
            String hmacAlgorithm = "HmacSHA512";
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "HmacSHA512");
            Mac mac = Mac.getInstance("HmacSHA512");
            mac.init(secretKeySpec);
            return this.toHexString(mac.doFinal(data.getBytes()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EncryptionException("Calculation of HMAC failed.", e);
        }
    }

    private byte hexToByte(String hexString) {
        int firstDigit = this.toDigit(hexString.charAt(0));
        int secondDigit = this.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    private int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private boolean compareHashes(byte[] originalHash, byte[] comparisonHash) {
        int diff = originalHash.length ^ comparisonHash.length;
        for (int i = 0; i < originalHash.length && i < comparisonHash.length; ++i) {
            diff |= originalHash[i] ^ comparisonHash[i];
        }
        return diff == 0;
    }
}

