/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.cases;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.event.Event;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.internal.EventCreationException;
import dev.fitko.fitconnect.api.exceptions.internal.ValidationException;
import dev.fitko.fitconnect.api.services.events.SecurityEventService;
import dev.fitko.fitconnect.api.services.validation.ValidationService;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SecurityEventTokenService
implements SecurityEventService {
    private final RSAKey signingKey;
    private final ValidationService validationService;
    private final ApplicationConfig config;

    public SecurityEventTokenService(ApplicationConfig config, ValidationService validationService, RSAKey signingKey) {
        this.config = config;
        this.signingKey = signingKey;
        this.validationService = validationService;
    }

    @Override
    public SignedJWT createAcceptSubmissionEvent(EventPayload eventPayload) {
        return this.signJWT(Event.ACCEPT_SUBMISSION, eventPayload);
    }

    @Override
    public SignedJWT createRejectSubmissionEvent(EventPayload eventPayload) {
        return this.signJWT(Event.REJECT_SUBMISSION, eventPayload);
    }

    private SignedJWT signJWT(Event event, EventPayload eventPayload) {
        String transactionId = "case:" + String.valueOf(eventPayload.getCaseId());
        String subject = "submission:" + String.valueOf(eventPayload.getSubmissionId());
        JWSSigner signer = this.getJwsSigner(this.signingKey);
        JWSHeader header = this.buildJwsHeader(this.signingKey.getKeyID());
        JWTClaimsSet claimsSet = this.buildJwtClaimsSet(event, eventPayload, transactionId, subject);
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        try {
            signedJWT.sign(signer);
            this.validateEventSchema(signedJWT.getPayload().toString());
            return signedJWT;
        }
        catch (JOSEException | ValidationException e) {
            throw new EventCreationException("Creating " + String.valueOf((Object)event) + " event JWT failed", e.getCause());
        }
    }

    private JWSSigner getJwsSigner(RSAKey rsaKey) {
        try {
            return new RSASSASigner(rsaKey);
        }
        catch (JOSEException e) {
            throw new EventCreationException("Error creating the RSASigner", e);
        }
    }

    private JWSHeader buildJwsHeader(String keyId) {
        try {
            return JWSHeader.parse(Map.of("typ", "secevent+jwt", "kid", keyId, "alg", "PS512"));
        }
        catch (ParseException e) {
            throw new EventCreationException("Parsing JWS header failed", e);
        }
    }

    private JWTClaimsSet buildJwtClaimsSet(Event event, EventPayload eventPayload, String transactionId, String subject) {
        return new JWTClaimsSet.Builder().claim("$schema", (Object)this.config.getSetSchemaWriteVersion()).issuer(eventPayload.getDestinationId().toString()).issueTime(new Date()).jwtID(UUID.randomUUID().toString()).subject(subject).claim("txn", (Object)transactionId).claim("events", this.buildEventsClaim(event, eventPayload)).build();
    }

    private Map<String, Object> buildEventsClaim(Event event, EventPayload eventPayload) {
        HashMap<String, Object> events = new HashMap<String, Object>();
        if (eventPayload.getProblems() != null && !eventPayload.getProblems().isEmpty()) {
            events.put("problems", eventPayload.getProblems());
        }
        if (event.equals((Object)Event.ACCEPT_SUBMISSION)) {
            String dataAuthTag = eventPayload.getDataAuthTag();
            String metadataAuthTag = eventPayload.getMetadataAuthTag();
            Map<UUID, String> attachmentAuthTags = eventPayload.getAttachmentAuthTags();
            events.put("authenticationTags", new AuthenticationTags(dataAuthTag, metadataAuthTag, attachmentAuthTags));
        }
        return Map.of(event.getSchemaUri(), events);
    }

    private void validateEventSchema(String eventPayload) {
        ValidationResult validationResult = this.validationService.validateSetEventSchema(eventPayload);
        if (validationResult.hasError()) {
            throw new ValidationException("Set event is invalid", validationResult.getError());
        }
    }
}

