/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.cases;

import com.nimbusds.jwt.SignedJWT;
import dev.fitko.fitconnect.api.domain.model.cases.Case;
import dev.fitko.fitconnect.api.domain.model.cases.Cases;
import dev.fitko.fitconnect.api.domain.model.event.Event;
import dev.fitko.fitconnect.api.domain.model.event.EventLog;
import dev.fitko.fitconnect.api.domain.model.event.EventLogEntry;
import dev.fitko.fitconnect.api.domain.model.event.Status;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.authtags.ValidatedAuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.submission.InvalidEventLog;
import dev.fitko.fitconnect.api.domain.model.event.problems.submission.MissingAuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.submission.NotExactlyOneSubmitEvent;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.domain.model.reply.SentReply;
import dev.fitko.fitconnect.api.domain.model.submission.SentSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.validation.ValidationContext;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.internal.EventLogException;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.exceptions.internal.SubmitEventNotFoundException;
import dev.fitko.fitconnect.api.services.auth.OAuthService;
import dev.fitko.fitconnect.api.services.events.CaseService;
import dev.fitko.fitconnect.api.services.events.EventLogVerificationService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.core.utils.EventLogUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseApiService
implements CaseService {
    public static final String CASES_PATH = "/v2/cases";
    public static final String CASE_PATH = "/v2/cases/%s";
    public static final String CASES_EVENTS_PATH = "/v2/cases/%s/events";
    public static final String SUBMISSIONS_EVENTS_PATH = "/v2/submissions/%s/events";
    public static final String REPLIES_EVENTS_PATH = "/v2/replies/%s/events";
    private static final int PAGE_LIMIT = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseApiService.class);
    private final OAuthService authService;
    private final HttpClient httpClient;
    private final EventLogVerificationService eventLogVerifier;
    private final String baseUrl;

    public CaseApiService(OAuthService authService, HttpClient httpClient, EventLogVerificationService eventLogVerifier, String baseUrl) {
        this.authService = authService;
        this.httpClient = httpClient;
        this.eventLogVerifier = eventLogVerifier;
        this.baseUrl = baseUrl;
    }

    @Override
    public List<EventLogEntry> getEventLogForCase(UUID destinationId, UUID caseId, AuthenticationTags authenticationTags) {
        String caseEventsUrl = String.format(this.baseUrl + CASES_EVENTS_PATH, caseId);
        List<String> eventLog = this.loadEventLog(caseEventsUrl);
        List<SignedJWT> events = EventLogUtil.getJWTSFromEvents(eventLog);
        SentSubmission sentSubmission = new SentSubmission(destinationId, null, caseId, authenticationTags);
        ValidationContext ctx = this.getValidationContext(sentSubmission);
        this.checkForValidationErrors(this.eventLogVerifier.validateEventLogs(ctx, events));
        return EventLogUtil.mapEventLogToEntries(events);
    }

    @Override
    public List<EventLogEntry> getEventLogForSubmission(UUID destinationId, UUID caseId, UUID submissionId, AuthenticationTags authenticationTags) {
        List<String> eventLog = this.loadEventLog(String.format(this.baseUrl + SUBMISSIONS_EVENTS_PATH, submissionId));
        List<SignedJWT> events = EventLogUtil.getJWTSFromEvents(eventLog);
        SentSubmission sentSubmission = new SentSubmission(destinationId, submissionId, caseId, authenticationTags);
        ValidationContext ctx = this.getValidationContext(sentSubmission);
        this.checkForValidationErrors(this.eventLogVerifier.validateEventLogs(ctx, events));
        return EventLogUtil.mapEventLogToEntries(events);
    }

    @Override
    public ValidatedAuthenticationTags getAuthenticationTags(Submission submission) throws RestApiException, EventLogException {
        List<SignedJWT> submitEvents = this.getEvents(SUBMISSIONS_EVENTS_PATH, submission.getSubmissionId(), Event.SUBMIT_SUBMISSION);
        return this.getValidatedAuthenticationTags(submission.getDestinationId(), submission.getCaseId(), submitEvents);
    }

    @Override
    public ValidatedAuthenticationTags getAuthenticationTags(Reply reply) throws RestApiException, EventLogException {
        List<SignedJWT> submitEvents = this.getEvents(REPLIES_EVENTS_PATH, reply.getReplyId(), Event.SUBMIT_REPLY);
        return this.getValidatedAuthenticationTags(null, reply.getCaseId(), submitEvents);
    }

    @Override
    public void sendEvent(UUID caseId, String signedAndSerializedSET) {
        String url = String.format(this.baseUrl + CASES_EVENTS_PATH, caseId);
        try {
            this.httpClient.post(url, this.buildHeaders("application/jose"), signedAndSerializedSET, Void.class);
        }
        catch (RestApiException e) {
            throw new RestApiException("Sending event failed", e);
        }
    }

    @Override
    public Status getStatus(SentSubmission sentSubmission) {
        SignedJWT latestEvent = this.getLogFilteredById(SUBMISSIONS_EVENTS_PATH, sentSubmission.getSubmissionId());
        ValidationContext validationContext = this.getValidationContext(sentSubmission);
        return this.getVerifiedStatus(validationContext, latestEvent);
    }

    @Override
    public Status getStatus(SentReply reply) {
        SignedJWT latestEvent = this.getLogFilteredById(REPLIES_EVENTS_PATH, reply.getReplyId());
        ValidationContext contextWithoutAuthTagValidation = ValidationContext.withoutAuthTagValidation(reply.getCaseId());
        return this.getVerifiedStatus(contextWithoutAuthTagValidation, latestEvent);
    }

    @Override
    public Status getSubmissionSubmitState(UUID caseId, UUID submissionId) {
        List<SignedJWT> submitEvents = this.getEvents(SUBMISSIONS_EVENTS_PATH, submissionId, Event.SUBMIT_SUBMISSION);
        if (submitEvents.size() != 1) {
            throw new SubmitEventNotFoundException("Event log does not contain exactly one submit event");
        }
        ValidationContext ctx = ValidationContext.withoutAuthTagValidation(caseId);
        this.checkForValidationErrors(this.eventLogVerifier.validateEventLogs(ctx, submitEvents));
        EventLogEntry eventLogEntry = EventLogUtil.eventToLogEntry(submitEvents.get(0));
        return Status.fromEventLogEntry(eventLogEntry);
    }

    @Override
    public Cases listCases(int limit, int offset) {
        return this.loadCases(limit, offset);
    }

    @Override
    public Case getCase(UUID caseId) {
        String url = String.format(this.baseUrl + CASE_PATH, caseId);
        try {
            return this.httpClient.get(url, this.buildHeaders(), Case.class).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException("Case query failed", e);
        }
    }

    private List<SignedJWT> getEvents(String urlBasePath, UUID submissionOrReplyId, Event event) {
        String caseEventsUrl = String.format(this.baseUrl + urlBasePath, submissionOrReplyId);
        List<String> eventLog = this.loadEventLog(caseEventsUrl);
        return EventLogUtil.getFilteredJwtsFromEventLog(submissionOrReplyId, event, eventLog);
    }

    private List<String> loadEventLog(String requestUrl) {
        ArrayList<String> eventLogs = new ArrayList<String>();
        int offset = 0;
        while (true) {
            String url = requestUrl + "?limit=100&offset=" + offset;
            EventLog page = this.fetchPage(url, EventLog.class, "EventLog query failed");
            eventLogs.addAll(page.getEventLogs());
            if (this.isLastPage(page, offset, 100)) break;
            offset += 100;
        }
        return eventLogs;
    }

    private Cases loadCases(int limit, int offset) {
        String url = this.baseUrl + "/v2/cases?limit=" + limit + "&offset=" + offset;
        return this.fetchPage(url, Cases.class, "Cases query failed");
    }

    private boolean isLastPage(EventLog page, int offset, int limit) {
        int currentFetchSize = page.getEventLogs().size();
        int nextOffset = offset + limit;
        return currentFetchSize < limit || nextOffset >= page.getTotalCount();
    }

    private <T> T fetchPage(String url, Class<T> responseType, String errorMessage) {
        try {
            return this.httpClient.get(url, this.buildHeaders(), responseType).getBody();
        }
        catch (RestApiException e) {
            throw new RestApiException(errorMessage, e);
        }
    }

    private Status getVerifiedStatus(ValidationContext validationContext, SignedJWT latestEvent) {
        if (latestEvent == null) {
            LOGGER.info("No events found");
            return new Status();
        }
        this.checkForValidationErrors(this.eventLogVerifier.validateEventLogs(validationContext, List.of(latestEvent)));
        EventLogEntry eventLogEntry = EventLogUtil.eventToLogEntry(latestEvent);
        return Status.fromEventLogEntry(eventLogEntry);
    }

    private SignedJWT getLogFilteredById(String urlBasePath, UUID id) {
        String caseEventsUrl = String.format(this.baseUrl + urlBasePath, id);
        List<String> eventLog = this.loadEventLog(caseEventsUrl);
        return EventLogUtil.getJWTSFromEvents(eventLog).stream().filter(EventLogUtil.eventSubjectEqualsId(id)).reduce((first, second) -> second).orElse(null);
    }

    private void checkForValidationErrors(List<ValidationResult> validationResults) {
        if (!validationResults.isEmpty()) {
            throw new EventLogException(this.joinMessages(validationResults));
        }
    }

    private String joinMessages(List<ValidationResult> validationResults) {
        return validationResults.stream().map(ValidationResult::getError).map(Throwable::getMessage).collect(Collectors.joining("\n"));
    }

    private Map<String, String> buildHeaders(String contentType) {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Content-Type", contentType));
    }

    private ValidationContext getValidationContext(SentSubmission sentSubmission) {
        UUID destinationId = sentSubmission.getDestinationId();
        UUID caseId = sentSubmission.getCaseId();
        if (sentSubmission.getAuthenticationTags() == null) {
            return ValidationContext.withoutAuthTagValidation(destinationId, caseId);
        }
        return ValidationContext.withAuthTagValidation(destinationId, caseId, sentSubmission.getAuthenticationTags());
    }

    private ValidatedAuthenticationTags getValidatedAuthenticationTags(UUID destinationId, UUID caseId, List<SignedJWT> submitEvents) {
        int submitEventSize = submitEvents.size();
        if (submitEventSize != 1) {
            if (submitEventSize == 0) {
                LOGGER.warn("No submit event found in event-log, expected exactly 1");
            } else {
                LOGGER.warn("Eventlog contains {} submit events, expected exactly 1", (Object)submitEventSize);
            }
            return ValidatedAuthenticationTags.fromInvalidTags(new NotExactlyOneSubmitEvent());
        }
        AuthenticationTags authenticationTags = EventLogUtil.getAuthTags(submitEvents.get(0));
        if (authenticationTags == null || authenticationTags.getMetadata() == null || authenticationTags.getData() == null) {
            return ValidatedAuthenticationTags.fromInvalidTags(new MissingAuthenticationTags());
        }
        ValidationContext ctx = ValidationContext.withAuthTagValidation(destinationId, caseId, authenticationTags);
        List<ValidationResult> validationResults = this.eventLogVerifier.validateEventLogs(ctx, submitEvents);
        if (!validationResults.isEmpty()) {
            return ValidatedAuthenticationTags.fromInvalidTags(new InvalidEventLog(), this.joinMessages(validationResults));
        }
        return ValidatedAuthenticationTags.fromValidTags(authenticationTags);
    }

    private Map<String, String> buildHeaders() {
        return new HashMap<String, String>(Map.of("Authorization", "Bearer " + this.authService.getCurrentToken().getAccessToken(), "Accept", "application/json", "Accept-Charset", StandardCharsets.UTF_8.toString()));
    }
}

