/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core.auth;

import dev.fitko.fitconnect.api.domain.auth.OAuthToken;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.services.auth.OAuthService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuthApiService
implements OAuthService {
    public static final String AUTH_TOKEN_PATH = "/token";
    public static final int VALIDITY_LEEWAY = 5;
    private static final Map<String, String> DEFAULT_CONTENT_TYPE = Map.of("Content-Type", "application/x-www-form-urlencoded");
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuthApiService.class);
    private final HttpClient httpClient;
    private final String authBaseUrl;
    private final String clientId;
    private final String clientSecret;
    private OAuthToken currentToken;
    private LocalDateTime tokenExpirationTime;

    public DefaultOAuthApiService(HttpClient httpClient, String clientId, String clientSecret, String authBaseUrl) {
        this.httpClient = httpClient;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authBaseUrl = authBaseUrl;
        this.resetExistingToken();
    }

    @Override
    public OAuthToken getCurrentToken() throws RestApiException {
        if (this.tokenExpired()) {
            LOGGER.info("Current token is expired, authenticating ...");
            this.authenticate();
        }
        return this.currentToken;
    }

    private boolean tokenExpired() {
        if (this.currentToken == null || this.tokenExpirationTime == null) {
            return true;
        }
        return this.tokenExpirationTime.minusSeconds(5L).isBefore(LocalDateTime.now());
    }

    private void resetExistingToken() {
        this.currentToken = null;
        this.tokenExpirationTime = null;
    }

    private void authenticate() {
        String requestBody = this.buildRequestBody(this.clientId, this.clientSecret);
        this.currentToken = this.performTokenRequest(requestBody);
        this.tokenExpirationTime = LocalDateTime.now().plusSeconds(this.currentToken.getExpiresIn().intValue());
    }

    private String buildRequestBody(String clientId, String clientSecret) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", "client_credentials");
        data.put("client_id", clientId);
        data.put("client_secret", clientSecret);
        return this.joinRequestParams(data);
    }

    private String joinRequestParams(HashMap<String, String> data) {
        return data.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }

    private OAuthToken performTokenRequest(String requestBody) throws RestApiException {
        try {
            LOGGER.info("Sending authentication request");
            return this.httpClient.post(this.authBaseUrl + AUTH_TOKEN_PATH, DEFAULT_CONTENT_TYPE, requestBody, OAuthToken.class).getBody();
        }
        catch (RestApiException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RestApiException("Could not retrieve OAuth token", e);
        }
    }
}

