/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.core;

import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.limits.submission.SubmissionLimits;
import dev.fitko.fitconnect.api.domain.model.cases.Case;
import dev.fitko.fitconnect.api.domain.model.cases.Cases;
import dev.fitko.fitconnect.api.domain.model.destination.Destination;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.event.Event;
import dev.fitko.fitconnect.api.domain.model.event.EventLogEntry;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.Status;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.authtags.ValidatedAuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.AttachmentForValidation;
import dev.fitko.fitconnect.api.domain.model.reply.AcceptReply;
import dev.fitko.fitconnect.api.domain.model.reply.AnnounceReply;
import dev.fitko.fitconnect.api.domain.model.reply.CreatedReply;
import dev.fitko.fitconnect.api.domain.model.reply.RepliesForPickup;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.domain.model.reply.SentReply;
import dev.fitko.fitconnect.api.domain.model.reply.SubmitReply;
import dev.fitko.fitconnect.api.domain.model.submission.AnnounceSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.CreatedSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.SentSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionsForPickup;
import dev.fitko.fitconnect.api.domain.model.submission.SubmitSubmission;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.api.exceptions.internal.DecryptionException;
import dev.fitko.fitconnect.api.exceptions.internal.EncryptionException;
import dev.fitko.fitconnect.api.exceptions.internal.EventCreationException;
import dev.fitko.fitconnect.api.exceptions.internal.EventLogException;
import dev.fitko.fitconnect.api.exceptions.internal.InvalidKeyException;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.exceptions.internal.VirusScanException;
import dev.fitko.fitconnect.api.services.crypto.CryptoService;
import dev.fitko.fitconnect.api.services.destination.DestinationService;
import dev.fitko.fitconnect.api.services.events.CaseService;
import dev.fitko.fitconnect.api.services.events.SecurityEventService;
import dev.fitko.fitconnect.api.services.keys.KeyService;
import dev.fitko.fitconnect.api.services.reply.ReplyService;
import dev.fitko.fitconnect.api.services.submission.SubmissionService;
import dev.fitko.fitconnect.api.services.validation.ValidationService;
import dev.fitko.fitconnect.api.services.validation.VirusScanService;
import dev.fitko.fitconnect.client.attachments.ConcurrencyLimiter;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitConnectDefaultService
implements FitConnectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FitConnectDefaultService.class);
    private final ValidationService validationService;
    private final ReplyService replyService;
    private final CryptoService cryptoService;
    private final SubmissionService submissionService;
    private final DestinationService destinationService;
    private final CaseService caseService;
    private final KeyService keyService;
    private final SecurityEventService securityEventService;
    private final ConcurrencyLimiter concurrencyLimiter;
    private final VirusScanService virusScanService;

    @Override
    public ValidationResult validateMetadataSchema(Metadata metadata) {
        LOGGER.info("Validating metadata");
        return this.validationService.validateMetadataSchema(metadata);
    }

    @Override
    public ValidationResult validateSubmissionMetadata(Metadata metadata, Submission submission, AuthenticationTags authenticationTags) throws RestApiException {
        LOGGER.info("Validating submission metadata");
        PublicDestination destination = this.submissionService.getDestination(submission.getDestinationId());
        return this.validationService.validateSubmissionMetadata(metadata, submission, destination, authenticationTags);
    }

    @Override
    public ValidationResult validateReplyMetadata(Metadata metadata, Reply reply, AuthenticationTags authenticationTags) throws RestApiException {
        LOGGER.info("Validating reply metadata");
        Case submissionCase = this.getCase(reply.getCaseId());
        PublicDestination destination = this.submissionService.getDestination(submissionCase.getDestinationId());
        return this.validationService.validateReplyMetadata(metadata, reply, destination, authenticationTags);
    }

    @Override
    public ValidationResult validateData(byte[] data, String encryptedData, Metadata metadata, String authenticationTags) {
        LOGGER.info("Validating data");
        return this.validationService.validateData(data, encryptedData, metadata, authenticationTags);
    }

    @Override
    public ValidationResult validateAttachments(List<AttachmentForValidation> attachmentsForValidation, AuthenticationTags authenticationTags) {
        LOGGER.info("Validating attachments");
        return this.validationService.validateAttachments(attachmentsForValidation, authenticationTags);
    }

    @Override
    public ValidationResult validateJsonSchema(byte[] json, URI schemaUri) {
        LOGGER.info("Validating submission data against JSON schema");
        return this.validationService.validateJsonSubmissionDataSchema(json, schemaUri);
    }

    @Override
    public ValidationResult validateXmlSchema(byte[] json, URI schemaUri) {
        LOGGER.info("Validating submission data against XML schema");
        return this.validationService.validateXmlSubmissionDataSchema(json, schemaUri);
    }

    @Override
    public ValidationResult validateJsonFormat(byte[] json) {
        LOGGER.info("Validating data JSON format");
        return this.validationService.validateJsonFormat(json);
    }

    @Override
    public ValidationResult validateXmlFormat(byte[] xml) {
        LOGGER.info("Validating data XML format");
        return this.validationService.validateXmlFormat(xml);
    }

    @Override
    public ValidationResult validateCallback(String hmac, Long timestampInSeconds, String httpBody, String callbackSecret) {
        LOGGER.info("Validating callback integrity");
        return this.validationService.validateCallback(hmac, timestampInSeconds, httpBody, callbackSecret);
    }

    @Override
    public String encryptBytes(RSAKey publicKey, byte[] data, String contentType) throws EncryptionException {
        return this.cryptoService.encryptBytes(publicKey, data, contentType);
    }

    @Override
    public JWEObject encryptInputStream(RSAKey publicKey, InputStream inputStream, String contentType) throws EncryptionException {
        return this.cryptoService.encryptInputStream(publicKey, inputStream, contentType);
    }

    @Override
    public String encryptObject(RSAKey encryptionKey, Object obj, String contentType) throws EncryptionException {
        return this.cryptoService.encryptObject(encryptionKey, obj, contentType);
    }

    @Override
    public byte[] decryptString(RSAKey privateKey, String encryptedContent) throws DecryptionException {
        return this.cryptoService.decryptToBytes(privateKey, encryptedContent);
    }

    @Override
    public String createHash(byte[] data) {
        return this.cryptoService.hashBytes(data);
    }

    @Override
    public String createHash(InputStream inputStream) {
        return this.cryptoService.hashStream(inputStream);
    }

    @Override
    public SubmissionsForPickup getAvailableSubmissions(UUID destinationId, int offset, int limit) throws RestApiException {
        LOGGER.info("Loading available submissions {}-{} for destination {}", new Object[]{offset, offset + limit, destinationId});
        return this.submissionService.pollAvailableSubmissionsForDestination(destinationId, offset, limit);
    }

    @Override
    public CreatedSubmission announceSubmission(AnnounceSubmission submission) throws RestApiException {
        LOGGER.info("Announcing new submission for destination {}", (Object)submission.getDestinationId());
        return this.submissionService.announceSubmission(submission);
    }

    @Override
    public Submission sendSubmission(SubmitSubmission submission) throws RestApiException {
        LOGGER.info("Sending submission {}", (Object)submission.getSubmissionId());
        return this.submissionService.sendSubmission(submission);
    }

    @Override
    public void uploadSubmissionAttachment(UUID submissionId, UUID attachmentId, String encryptedAttachment) throws RestApiException {
        try (ConcurrencyLimiter.AcquiredSemaphore ignored = this.concurrencyLimiter.acquire();){
            LOGGER.info("Uploading attachment {} for submission {}", (Object)attachmentId, (Object)submissionId);
            this.submissionService.uploadAttachment(submissionId, attachmentId, encryptedAttachment);
        }
    }

    @Override
    public void uploadSubmissionAttachmentStream(UUID submissionId, UUID attachmentId, InputStream encryptedAttachment) throws RestApiException {
        try (ConcurrencyLimiter.AcquiredSemaphore ignored = this.concurrencyLimiter.acquire();){
            LOGGER.info("Uploading attachment {} for submission {}", (Object)attachmentId, (Object)submissionId);
            this.submissionService.uploadAttachmentStream(submissionId, attachmentId, encryptedAttachment);
        }
    }

    @Override
    public String getSubmissionAttachment(UUID submissionId, UUID attachmentId) throws RestApiException {
        try (ConcurrencyLimiter.AcquiredSemaphore ignored = this.concurrencyLimiter.acquire();){
            LOGGER.info("Loading attachment {} for submission {}", (Object)attachmentId, (Object)submissionId);
            String string = this.submissionService.getAttachment(submissionId, attachmentId);
            return string;
        }
    }

    @Override
    public SubmissionLimits getDestinationAttachmentLimits(UUID destinationId) throws RestApiException {
        LOGGER.info("Loading attachment limits for destination {}", (Object)destinationId);
        return this.submissionService.getDestinationAttachmentLimits(destinationId);
    }

    @Override
    public SubmissionLimits getCaseAttachmentLimits(UUID caseId) throws RestApiException {
        LOGGER.info("Loading attachment limits for case {}", (Object)caseId);
        return this.submissionService.getCaseAttachmentLimits(caseId);
    }

    @Override
    public Submission getSubmission(UUID submissionId) throws RestApiException {
        LOGGER.info("Loading submission {}", (Object)submissionId);
        return this.submissionService.getSubmission(submissionId);
    }

    @Override
    public void acceptSubmission(EventPayload eventPayload) throws RestApiException, EventCreationException {
        LOGGER.info("Accepting submission {}", (Object)eventPayload.getSubmissionId());
        SignedJWT confirmedSubmissionEvent = this.securityEventService.createAcceptSubmissionEvent(eventPayload);
        this.caseService.sendEvent(eventPayload.getCaseId(), confirmedSubmissionEvent.serialize());
        LOGGER.info("CONFIRMED submission {} successfully", (Object)eventPayload.getSubmissionId());
    }

    @Override
    public void rejectSubmission(EventPayload eventPayload) throws RestApiException, EventCreationException {
        LOGGER.info("Rejecting submission {}", (Object)eventPayload.getSubmissionId());
        SignedJWT rejectSubmissionEvent = this.securityEventService.createRejectSubmissionEvent(eventPayload);
        this.caseService.sendEvent(eventPayload.getCaseId(), rejectSubmissionEvent.serialize());
        LOGGER.info("REJECTED submission {}", (Object)eventPayload.getSubmissionId());
    }

    @Override
    public Destination getPrivateDestination(UUID destinationId) throws RestApiException {
        LOGGER.info("Loading destination {}", (Object)destinationId);
        return this.destinationService.getDestination(destinationId);
    }

    @Override
    public PublicDestination getPublicDestination(UUID destinationId) throws RestApiException {
        LOGGER.info("Loading destination {}", (Object)destinationId);
        return this.submissionService.getDestination(destinationId);
    }

    @Override
    public RSAKey getEncryptionKeyForDestination(PublicDestination destination) throws RestApiException, InvalidKeyException {
        LOGGER.info("Loading encryption key for destination id {}", (Object)destination.getDestinationId());
        return this.keyService.getPublicEncryptionKey(destination);
    }

    @Override
    public RSAKey getEncryptionKeyForDestination(UUID destinationId) throws RestApiException, InvalidKeyException {
        LOGGER.info("Loading encryption key for destination id {}", (Object)destinationId);
        PublicDestination destination = this.getPublicDestination(destinationId);
        return this.keyService.getPublicEncryptionKey(destination);
    }

    @Override
    public List<EventLogEntry> getEventLogForCase(UUID destinationId, UUID caseId, AuthenticationTags authenticationTags) {
        LOGGER.info("Loading event log for case {}", (Object)caseId);
        return this.caseService.getEventLogForCase(destinationId, caseId, authenticationTags);
    }

    @Override
    public List<EventLogEntry> getEventLogForSubmission(UUID destinationId, UUID caseId, UUID submissionId, AuthenticationTags authenticationTags) {
        LOGGER.info("Loading event log for submission {}", (Object)submissionId);
        return this.caseService.getEventLogForSubmission(destinationId, caseId, submissionId, authenticationTags);
    }

    @Override
    public Status getStatus(SentSubmission sentSubmission) throws RestApiException {
        LOGGER.info("Loading status of submission {}", (Object)sentSubmission.getSubmissionId());
        return this.caseService.getStatus(sentSubmission);
    }

    @Override
    public Status getStatus(SentReply reply) throws RestApiException {
        LOGGER.info("Loading status of reply {}", (Object)reply.getReplyId());
        return this.caseService.getStatus(reply);
    }

    @Override
    public ValidatedAuthenticationTags getSubmissionAuthenticationTags(Submission submission) throws RestApiException, EventLogException {
        LOGGER.info("Loading authentication tags of {} event for submission {}", (Object)Event.SUBMIT_SUBMISSION, (Object)submission.getSubmissionId());
        return this.caseService.getAuthenticationTags(submission);
    }

    @Override
    public ValidatedAuthenticationTags getReplyAuthenticationTags(Reply reply) throws RestApiException, EventLogException {
        LOGGER.info("Loading authentication tags of {} event for reply {}", (Object)Event.SUBMIT_REPLY, (Object)reply.getReplyId());
        return this.caseService.getAuthenticationTags(reply);
    }

    @Override
    public Cases listCases(int limit, int offset) throws RestApiException, EventLogException {
        LOGGER.info("Loading active cases");
        return this.caseService.listCases(limit, offset);
    }

    @Override
    public Case getCase(UUID caseId) throws RestApiException, EventLogException {
        LOGGER.info("Loading case {}", (Object)caseId);
        return this.caseService.getCase(caseId);
    }

    @Override
    public Reply getReply(UUID replyId) throws RestApiException {
        LOGGER.info("Loading reply {}", (Object)replyId);
        return this.replyService.getReply(replyId);
    }

    @Override
    public RepliesForPickup getAvailableReplies(int limit, int offset) throws RestApiException {
        LOGGER.info("Loading available replies");
        return this.replyService.getAvailableReplies(limit, offset);
    }

    @Override
    public SentReply submitReply(UUID replyId, SubmitReply submitReply) {
        LOGGER.info("Submitting reply {}", (Object)replyId);
        return this.replyService.submitReply(replyId, submitReply);
    }

    @Override
    public CreatedReply announceReply(AnnounceReply announceReply) {
        LOGGER.info("Announcing new reply for case {}", (Object)announceReply.getCaseId());
        return this.replyService.announceReply(announceReply);
    }

    @Override
    public String acceptReply(UUID replyId, AcceptReply acceptReply) {
        LOGGER.info("Accepting reply {}", (Object)replyId);
        return this.replyService.acceptReply(replyId, acceptReply);
    }

    @Override
    public String rejectReply(UUID replyId, List<Problem> problems) {
        LOGGER.info("Rejecting reply {}", (Object)replyId);
        return this.replyService.rejectReply(replyId, problems);
    }

    @Override
    public Status getSubmitState(Submission submission) {
        LOGGER.info("Loading submit state for submission {}", (Object)submission.getSubmissionId());
        return this.caseService.getSubmissionSubmitState(submission.getCaseId(), submission.getSubmissionId());
    }

    @Override
    public void uploadReplyAttachment(UUID replyId, UUID attachmentId, String encryptedAttachment) {
        try (ConcurrencyLimiter.AcquiredSemaphore ignored = this.concurrencyLimiter.acquire();){
            LOGGER.info("Uploading attachment {} for reply {}", (Object)attachmentId, (Object)replyId);
            this.replyService.uploadAttachment(replyId, attachmentId, encryptedAttachment);
        }
    }

    @Override
    public String getReplyAttachment(UUID replyId, UUID attachmentId) {
        try (ConcurrencyLimiter.AcquiredSemaphore ignored = this.concurrencyLimiter.acquire();){
            LOGGER.info("Loading attachment {} for reply {}", (Object)attachmentId, (Object)replyId);
            String string = this.replyService.getAttachment(replyId, attachmentId);
            return string;
        }
    }

    @Override
    public VirusScanResult scanBytesForViruses(byte[] data) throws VirusScanException {
        LOGGER.info("Scanning byte array for viruses");
        return this.virusScanService.scanBytes(data);
    }

    @Override
    public VirusScanResult scanStreamForViruses(InputStream inputStream) throws VirusScanException {
        LOGGER.info("Scanning input stream for viruses");
        return this.virusScanService.scanStream(inputStream);
    }

    @Override
    public VirusScanResult scanFileForViruses(Path filePath) throws VirusScanException {
        LOGGER.info("Scanning file for viruses");
        return this.virusScanService.scanFile(filePath);
    }

    @Generated
    public static FitConnectDefaultServiceBuilder builder() {
        return new FitConnectDefaultServiceBuilder();
    }

    @Generated
    public FitConnectDefaultService(ValidationService validationService, ReplyService replyService, CryptoService cryptoService, SubmissionService submissionService, DestinationService destinationService, CaseService caseService, KeyService keyService, SecurityEventService securityEventService, ConcurrencyLimiter concurrencyLimiter, VirusScanService virusScanService) {
        this.validationService = validationService;
        this.replyService = replyService;
        this.cryptoService = cryptoService;
        this.submissionService = submissionService;
        this.destinationService = destinationService;
        this.caseService = caseService;
        this.keyService = keyService;
        this.securityEventService = securityEventService;
        this.concurrencyLimiter = concurrencyLimiter;
        this.virusScanService = virusScanService;
    }

    @Generated
    public static class FitConnectDefaultServiceBuilder {
        @Generated
        private ValidationService validationService;
        @Generated
        private ReplyService replyService;
        @Generated
        private CryptoService cryptoService;
        @Generated
        private SubmissionService submissionService;
        @Generated
        private DestinationService destinationService;
        @Generated
        private CaseService caseService;
        @Generated
        private KeyService keyService;
        @Generated
        private SecurityEventService securityEventService;
        @Generated
        private ConcurrencyLimiter concurrencyLimiter;
        @Generated
        private VirusScanService virusScanService;

        @Generated
        FitConnectDefaultServiceBuilder() {
        }

        @Generated
        public FitConnectDefaultServiceBuilder validationService(ValidationService validationService) {
            this.validationService = validationService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder replyService(ReplyService replyService) {
            this.replyService = replyService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder cryptoService(CryptoService cryptoService) {
            this.cryptoService = cryptoService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder submissionService(SubmissionService submissionService) {
            this.submissionService = submissionService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder destinationService(DestinationService destinationService) {
            this.destinationService = destinationService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder caseService(CaseService caseService) {
            this.caseService = caseService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder keyService(KeyService keyService) {
            this.keyService = keyService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder securityEventService(SecurityEventService securityEventService) {
            this.securityEventService = securityEventService;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder concurrencyLimiter(ConcurrencyLimiter concurrencyLimiter) {
            this.concurrencyLimiter = concurrencyLimiter;
            return this;
        }

        @Generated
        public FitConnectDefaultServiceBuilder virusScanService(VirusScanService virusScanService) {
            this.virusScanService = virusScanService;
            return this;
        }

        @Generated
        public FitConnectDefaultService build() {
            return new FitConnectDefaultService(this.validationService, this.replyService, this.cryptoService, this.submissionService, this.destinationService, this.caseService, this.keyService, this.securityEventService, this.concurrencyLimiter, this.virusScanService);
        }

        @Generated
        public String toString() {
            return "FitConnectDefaultService.FitConnectDefaultServiceBuilder(validationService=" + String.valueOf(this.validationService) + ", replyService=" + String.valueOf(this.replyService) + ", cryptoService=" + String.valueOf(this.cryptoService) + ", submissionService=" + String.valueOf(this.submissionService) + ", destinationService=" + String.valueOf(this.destinationService) + ", caseService=" + String.valueOf(this.caseService) + ", keyService=" + String.valueOf(this.keyService) + ", securityEventService=" + String.valueOf(this.securityEventService) + ", concurrencyLimiter=" + String.valueOf(this.concurrencyLimiter) + ", virusScanService=" + String.valueOf(this.virusScanService) + ")";
        }
    }
}

