/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.zbp;

import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.config.ZBPCertConfig;
import dev.fitko.fitconnect.api.domain.zbp.ZBPEnvelope;
import dev.fitko.fitconnect.api.domain.zbp.attachment.ZBPApiAttachment;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessage;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessageResponse;
import dev.fitko.fitconnect.api.domain.zbp.state.CreateState;
import dev.fitko.fitconnect.client.zbp.ZBPEnvelopeBuilder;
import dev.fitko.fitconnect.core.crypto.utils.CertUtils;
import dev.fitko.fitconnect.core.zbp.ZBPApiService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZBPServiceAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZBPServiceAdapter.class);
    private final ZBPApiService apiService;
    private final RSAKey signingKey;
    private final String senderCert;

    public ZBPServiceAdapter(ZBPApiService apiService, ZBPCertConfig certConfig) {
        this.apiService = apiService;
        this.signingKey = certConfig.getClientPrivateKey();
        this.senderCert = certConfig.getClientCertificate();
    }

    public CreateMessageResponse sendMessage(CreateMessage createMessage, List<ZBPApiAttachment> attachments, String authorCertificate, String authorToken) {
        LOGGER.info("Sending new message with {} attachment(s) to ZBP mailbox {}", (Object)attachments.size(), (Object)createMessage.getMailboxUuid());
        ZBPEnvelope messageEnvelope = ZBPEnvelopeBuilder.fromSenderPayload(createMessage, this.signingKey, authorCertificate, authorToken);
        String signer = CertUtils.getSubjectCNFromCertificate(this.senderCert);
        return this.apiService.sendMessageToMailbox(this.signingKey, signer, messageEnvelope, attachments);
    }

    public void createNewState(CreateState createState, String authorCertificate, String authorToken) {
        LOGGER.info("Creating state {} for application {}", (Object)createState.getState(), (Object)createState.getApplicationId());
        ZBPEnvelope createStateEnvelope = ZBPEnvelopeBuilder.fromSenderPayload(createState, this.signingKey, authorCertificate, authorToken);
        String signer = CertUtils.getSubjectCNFromCertificate(this.senderCert);
        this.apiService.createNewState(this.signingKey, signer, createStateEnvelope);
    }
}

