/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.zbp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.domain.zbp.AuthorKeyPair;
import dev.fitko.fitconnect.api.domain.zbp.ZBPEnvelope;
import dev.fitko.fitconnect.client.zbp.ObjectMapperProvider;
import dev.fitko.fitconnect.core.crypto.utils.CertUtils;
import dev.fitko.fitconnect.core.zbp.TokenGenerator;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import lombok.Generated;

public final class ZBPEnvelopeBuilder {
    private static final ObjectMapper MAPPER = ObjectMapperProvider.createObjectMapper();

    public static byte[] fromAuthorPayload(Object payload, AuthorKeyPair authorKeyPair) {
        String authorCertificate = authorKeyPair.getAuthorCertificateAsPem();
        RSAKey authorPrivateKey = authorKeyPair.getAuthorPrivateKey();
        String signer = CertUtils.getSubjectCNFromCertificate(authorCertificate);
        String token = TokenGenerator.buildToken(authorPrivateKey, signer);
        ZBPEnvelope envelope = ZBPEnvelopeBuilder.buildEnvelope(payload, authorPrivateKey, authorCertificate, token);
        return ZBPEnvelopeBuilder.serializeToByteArray(envelope);
    }

    public static ZBPEnvelope fromSenderPayload(Object payload, RSAKey senderPrivateKey, String authorCertificate, String authorToken) {
        return ZBPEnvelopeBuilder.buildEnvelope(payload, senderPrivateKey, authorCertificate, authorToken);
    }

    private static ZBPEnvelope buildEnvelope(Object payload, RSAKey privateKey, String authorCertificate, String authorToken) {
        return ZBPEnvelope.builder().content(ZBPEnvelopeBuilder.serializeToJson(payload)).sha512sum(ZBPEnvelopeBuilder.signPayload(payload, privateKey)).authorCertificate(authorCertificate).authorToken(authorToken).build();
    }

    private static String signPayload(Object input, RSAKey key) {
        try {
            Signature signature = Signature.getInstance("SHA512withRSA");
            signature.initSign(key.toPrivateKey());
            signature.update(MAPPER.writeValueAsBytes(input));
            byte[] encoded = Base64.getEncoder().encode(signature.sign());
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException | JOSEException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] serializeToByteArray(Object obj) {
        try {
            return MAPPER.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String serializeToJson(Object payload) {
        return new String(ZBPEnvelopeBuilder.serializeToByteArray(payload), StandardCharsets.UTF_8);
    }

    @Generated
    private ZBPEnvelopeBuilder() {
    }
}

