/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.zbp;

import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.zbp.attachment.ZBPApiAttachment;
import dev.fitko.fitconnect.api.domain.zbp.attachment.ZBPAttachmentMetadata;
import dev.fitko.fitconnect.api.services.crypto.MessageDigestService;
import dev.fitko.fitconnect.core.crypto.HashService;
import lombok.Generated;

public class ZBPAttachmentMetadataBuilder {
    private static final MessageDigestService HASH_SERVICE = new HashService();

    public static ZBPAttachmentMetadata from(String filename, byte[] data) {
        return new ZBPAttachmentMetadata(filename, ZBPAttachmentMetadataBuilder.calcHash(data), data.length);
    }

    public static ZBPAttachmentMetadata from(ZBPApiAttachment zbpApiAttachment) {
        return new ZBPAttachmentMetadata(zbpApiAttachment.getFilename(), ZBPAttachmentMetadataBuilder.calcHash(zbpApiAttachment.getData()), zbpApiAttachment.getData().length);
    }

    public static ZBPAttachmentMetadata from(Attachment fitConnectAttachment) {
        return new ZBPAttachmentMetadata(fitConnectAttachment.getFileName(), ZBPAttachmentMetadataBuilder.calcHash(fitConnectAttachment.getDataAsBytes()), fitConnectAttachment.getDataAsBytes().length);
    }

    private static String calcHash(byte[] data) {
        byte[] hash = HASH_SERVICE.createHash(data);
        return HASH_SERVICE.toHexString(hash);
    }

    @Generated
    private ZBPAttachmentMetadataBuilder() {
    }
}

