/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.config.Version;
import dev.fitko.fitconnect.api.config.chunking.AttachmentChunkingConfig;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import dev.fitko.fitconnect.api.domain.model.destination.DestinationReplyChannels;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.destination.Service;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationFitConnect;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import dev.fitko.fitconnect.api.domain.model.metadata.data.MimeType;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import dev.fitko.fitconnect.api.domain.sender.SendableEncryptedSubmission;
import dev.fitko.fitconnect.api.domain.sender.SendableSubmission;
import dev.fitko.fitconnect.api.domain.subscriber.SendableReply;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.core.utils.Preconditions;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SubmissionValidator {
    private final FitConnectService fitConnectService;

    public SubmissionValidator(FitConnectService fitConnectService) {
        this.fitConnectService = fitConnectService;
    }

    public void ensureValidDataPayload(SendableEncryptedSubmission sendableEncryptedSubmission, PublicDestination destination) {
        Preconditions.checkArgumentAndThrow(sendableEncryptedSubmission == null, "Encrypted payload must not be null.");
        Preconditions.checkArgumentAndThrow(sendableEncryptedSubmission.getData() == null, "Encrypted data is mandatory, but was null.");
        Preconditions.checkArgumentAndThrow(sendableEncryptedSubmission.getMetadata() == null, "Encrypted metadata must not be null.");
        this.testDefaults(destination, sendableEncryptedSubmission.getServiceType().getIdentifier(), sendableEncryptedSubmission.getCallback());
    }

    public void ensureValidDataPayload(SendableSubmission sendableSubmission, PublicDestination destination) {
        Preconditions.checkArgumentAndThrow(sendableSubmission == null, "Submission must not be null.");
        this.testDataFormat(sendableSubmission.getAttachments(), sendableSubmission.getSubmissionSchema().getMimeType(), sendableSubmission.getData());
        this.testDefaults(sendableSubmission, destination);
    }

    private void testDataFormat(List<Attachment> attachments, MimeType dataMimeType, byte[] data) {
        List dataAttachments = attachments.stream().filter(a -> a.getPurpose().equals((Object)Purpose.DATA)).collect(Collectors.toList());
        if (dataAttachments.size() > 1) {
            throw new IllegalArgumentException("Data as an attachment can only be set once, found " + dataAttachments.size() + " entries");
        }
        if (dataAttachments.size() == 1) {
            this.testOnValidDataFormat(((Attachment)dataAttachments.get(0)).getDataAsBytes(), dataMimeType);
        } else {
            Preconditions.checkArgumentAndThrow(data == null || data.length == 0, "Data payload is mandatory, but was null or empty.");
            this.testOnValidDataFormat(data, dataMimeType);
        }
    }

    public void ensureValidDataPayload(SendableReply sendableReply, PublicDestination destination) {
        Preconditions.checkArgumentAndThrow(sendableReply == null, "Reply must not be null.");
        Preconditions.checkArgumentAndThrow(sendableReply.getReplyEncryptionKey() == null, "Public reply encryption key is mandatory, but was null");
        this.checkMatchingDataSchemaOnDestination(sendableReply.getSchemaUri(), sendableReply.getDataMimeType(), destination);
        this.testDataFormat(sendableReply.getAttachments(), sendableReply.getDataMimeType(), sendableReply.getData());
    }

    public boolean destinationSupportsAttachmentChunking(PublicDestination destination, List<Attachment> attachments, AttachmentChunkingConfig chunkingConfig) {
        Preconditions.checkArgumentAndThrow(destination.getMetadataVersions() == null, "Metadata versions not present on destination " + String.valueOf(destination.getDestinationId()));
        boolean metadataSupportsChunking = destination.getMetadataVersions().stream().map(Version::new).anyMatch(version -> version.isGreaterOrEqualThan(ApplicationConfig.MIN_METADATA_VERSION_WITH_CHUNKING_SUPPORT));
        if (!metadataSupportsChunking && !attachments.isEmpty() && (chunkingConfig.isChunkAllAttachments() || attachments.stream().anyMatch(Attachment::isLargeAttachment))) {
            throw new IllegalArgumentException("Submission contains chunked attachments but destination does not support chunking. At least metadata version " + String.valueOf(ApplicationConfig.MIN_METADATA_VERSION_WITH_CHUNKING_SUPPORT) + " is required.");
        }
        return metadataSupportsChunking;
    }

    private void testDefaults(PublicDestination destination, String serviceIdentifier, Callback callback) {
        Preconditions.checkArgumentAndThrow(destination == null, "DestinationId is mandatory, but was null.");
        Preconditions.checkArgumentAndThrow(serviceIdentifier == null, "Leika key is mandatory, but was null.");
        Preconditions.checkArgumentAndThrow(this.invalidLeikaKeyPattern(serviceIdentifier), "LeikaKey has invalid format, please follow: ^urn:[a-z0-9][a-z0-9-]{0,31}:[a-z0-9()+,.:=@;$_!*'%/?#-]+$.");
        if (this.serviceTypeDoesNotMatchDestination(destination, serviceIdentifier)) {
            throw new IllegalArgumentException("Provided service type '" + serviceIdentifier + "' is not allowed by the destination ");
        }
        if (callback != null) {
            this.checkCallbackFormat(callback);
        }
    }

    private void testDefaults(SendableSubmission sendableSubmission, PublicDestination destination) {
        Preconditions.checkArgumentAndThrow(sendableSubmission.getDestinationId() == null, "DestinationId is mandatory, but was null.");
        Preconditions.checkArgumentAndThrow(sendableSubmission.getServiceType().getIdentifier() == null, "Leika key is mandatory, but was null.");
        Preconditions.checkArgumentAndThrow(this.invalidLeikaKeyPattern(sendableSubmission.getServiceType().getIdentifier()), "LeikaKey has invalid format, please follow: ^urn:[a-z0-9][a-z0-9-]{0,31}:[a-z0-9()+,.:=@;$_!*'%/?#-]+$.\")");
        if (this.serviceTypeDoesNotMatchDestination(destination, sendableSubmission.getServiceType().getIdentifier())) {
            throw new IllegalArgumentException("Provided service type '" + sendableSubmission.getServiceType().getIdentifier() + "' is not allowed by the destination ");
        }
        SubmissionSchema submissionSchema = sendableSubmission.getSubmissionSchema();
        this.checkMatchingDataSchemaOnDestination(submissionSchema.getSchemaUri(), submissionSchema.getMimeType(), destination);
        this.checkMatchingProcessingStandardsOnDestination(destination.getPublicServices(), sendableSubmission.getReplyChannel(), sendableSubmission.getServiceType().getIdentifier(), sendableSubmission.getSubmissionSchema());
        if (sendableSubmission.getCallback() != null) {
            this.checkCallbackFormat(sendableSubmission.getCallback());
        }
    }

    private void checkMatchingProcessingStandardsOnDestination(Set<Service> services, ReplyChannel submissionReplyChannel, String serviceIdentifier, SubmissionSchema submissionSchema) {
        if (this.processingStandardsDoNotMatchDestination(services, submissionReplyChannel, serviceIdentifier, submissionSchema)) {
            throw new IllegalArgumentException("FIT-Connect reply channel processing standard(s) do not match any of the destination services");
        }
    }

    private boolean processingStandardsDoNotMatchDestination(Set<Service> services, ReplyChannel submissionReplyChannel, String serviceIdentifier, SubmissionSchema submissionSchema) {
        if (services == null || services.isEmpty() || services.stream().noneMatch(s -> s.getReplyChannels() != null) || submissionReplyChannel == null || submissionReplyChannel.getFitConnect() == null) {
            return false;
        }
        Optional<DestinationFitConnect> matchingStandardsFound = services.stream().filter(service -> service.getIdentifier().equals(serviceIdentifier)).filter(service -> service.getSubmissionSchemas().stream().anyMatch(schema -> schema.equals(submissionSchema))).map(Service::getReplyChannels).map(DestinationReplyChannels::getDestinationFitConnect).filter(Objects::nonNull).filter(SubmissionValidator.matchingProcessingStandards(submissionReplyChannel)).findAny();
        return matchingStandardsFound.isEmpty();
    }

    private static Predicate<DestinationFitConnect> matchingProcessingStandards(ReplyChannel submissionReplyChannel) {
        return destinationFitConnect -> new HashSet<String>(destinationFitConnect.getProcessStandards()).containsAll(submissionReplyChannel.getFitConnect().getProcessStandards());
    }

    private void checkMatchingDataSchemaOnDestination(URI submissionSchemaUri, MimeType dataMimeType, PublicDestination destination) {
        if (this.mimeTypeAndSchemaUriDoNotMatchDestination(destination, dataMimeType, submissionSchemaUri)) {
            String allowedSchemas = destination.getPublicServices().stream().flatMap(service -> service.getSubmissionSchemas().stream()).filter(Objects::nonNull).map(schema -> String.valueOf((Object)schema.getMimeType()) + " => " + String.valueOf(schema.getSchemaUri())).collect(Collectors.joining("\n"));
            if (allowedSchemas.isEmpty()) {
                throw new IllegalArgumentException("Destination has no available schemaUri for requested uri " + String.valueOf(submissionSchemaUri));
            }
            throw new IllegalArgumentException("Please specify a valid schemaUri for the submission. The destination allows: " + allowedSchemas);
        }
    }

    private boolean serviceTypeDoesNotMatchDestination(PublicDestination destination, String serviceIdentifier) {
        return destination.getPublicServices().stream().map(Service::getIdentifier).filter(Objects::nonNull).filter(destinationServiceIdentifier -> destinationServiceIdentifier.equals(serviceIdentifier)).findFirst().isEmpty();
    }

    private boolean mimeTypeAndSchemaUriDoNotMatchDestination(PublicDestination destination, MimeType mimeType, URI schemaUri) {
        return destination.getPublicServices().stream().flatMap(service -> service.getSubmissionSchemas().stream()).filter(Objects::nonNull).filter(schema -> schema.getMimeType().equals((Object)mimeType)).filter(schema -> schema.getSchemaUri().equals(schemaUri)).findFirst().isEmpty();
    }

    private void testOnValidDataFormat(byte[] data, MimeType dataMimeType) {
        if (dataMimeType.equals((Object)MimeType.APPLICATION_JSON)) {
            this.checkJsonFormat(data);
        } else if (dataMimeType.equals((Object)MimeType.APPLICATION_XML)) {
            this.checkXmlFormat(data);
        }
    }

    private void checkXmlFormat(byte[] xmlData) {
        ValidationResult validationResult = this.fitConnectService.validateXmlFormat(xmlData);
        if (validationResult.hasError()) {
            throw new IllegalArgumentException("Data is not in expected xml format, please provide valid xml: " + validationResult.getError().getMessage());
        }
    }

    private void checkJsonFormat(byte[] jsonData) {
        ValidationResult validationResult = this.fitConnectService.validateJsonFormat(jsonData);
        if (validationResult.hasError()) {
            throw new IllegalArgumentException("Data is not in expected json format, please provide valid json: " + validationResult.getError().getMessage());
        }
    }

    private void checkCallbackFormat(Callback callback) {
        if (callback.getUri() == null || !callback.getUri().getScheme().equals("https")) {
            throw new IllegalArgumentException("Callback URI " + String.valueOf(callback.getUri()) + " must be a secure https connection");
        }
        if (callback.getSecret() == null || callback.getSecret().length() < 32) {
            throw new IllegalArgumentException("Callback secret must have a length of at least 32 characters");
        }
    }

    private boolean invalidLeikaKeyPattern(String leikaKey) {
        return !ApplicationConfig.LEIKA_KEY_PATTERN.matcher(leikaKey).matches();
    }
}

