/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import dev.fitko.fitconnect.api.domain.model.attachment.AttachmentPayload;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.submission.AnnounceSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.SentSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmitSubmission;
import dev.fitko.fitconnect.api.domain.sender.SendableEncryptedSubmission;
import dev.fitko.fitconnect.api.domain.sender.SendableSubmission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SubmissionBuilder {
    private SubmissionBuilder() {
    }

    public static AnnounceSubmission buildCreateSubmission(SendableSubmission sendableSubmission, List<AttachmentPayload> attachments) {
        return AnnounceSubmission.builder().destinationId(sendableSubmission.getDestinationId()).caseId(sendableSubmission.getCaseId()).announcedAttachments(attachments.stream().flatMap(SubmissionBuilder.getAttachmentIds()).collect(Collectors.toList())).callback(sendableSubmission.getCallback()).publicService(sendableSubmission.getServiceType()).region(sendableSubmission.getServiceRegion()).build();
    }

    public static AnnounceSubmission buildCreateSubmission(SendableEncryptedSubmission sendableSubmission, Map<UUID, String> attachments) {
        return AnnounceSubmission.builder().destinationId(sendableSubmission.getDestinationId()).caseId(sendableSubmission.getCaseId()).announcedAttachments(new ArrayList<UUID>(attachments.keySet())).callback(sendableSubmission.getCallback()).publicService(sendableSubmission.getServiceType()).region(sendableSubmission.getServiceRegion()).build();
    }

    public static SubmitSubmission buildSubmitSubmission(UUID submissionId, String encryptedData, String encryptedMetadata) {
        SubmitSubmission submission = new SubmitSubmission();
        submission.setSubmissionId(submissionId);
        submission.setEncryptedData(encryptedData);
        submission.setEncryptedMetadata(encryptedMetadata);
        return submission;
    }

    public static SentSubmission buildSentSubmission(Submission submission, AuthenticationTags authenticationTags) {
        return SentSubmission.builder().submissionId(submission.getSubmissionId()).caseId(submission.getCaseId()).destinationId(submission.getDestinationId()).authenticationTags(authenticationTags).build();
    }

    private static Function<AttachmentPayload, Stream<UUID>> getAttachmentIds() {
        return payload -> payload.hasFragmentedPayload() ? payload.getFragmentIds().stream() : Stream.of(payload.getAttachmentId());
    }
}

