/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import dev.fitko.fitconnect.api.config.resources.SchemaResourceConfig;
import dev.fitko.fitconnect.api.domain.schema.SchemaResources;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectInitialisationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public final class ResourceLoadingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLoadingUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadYaml(String path, Class<T> returnType) {
        try (InputStream is = ResourceLoadingUtils.class.getClassLoader().getResourceAsStream(path);){
            Object object = new Yaml().loadAs(is, returnType);
            return (T)object;
        }
        catch (Exception e) {
            throw new FitConnectInitialisationException("Yaml resource from path  " + path + " could not be loaded", e);
        }
    }

    public static String readKeyFromPath(String keyPath) {
        try {
            return Files.readString(Path.of(keyPath, new String[0]));
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error("Could not read key from path '{}'. Please provide a valid path in your config.yml", (Object)keyPath);
            throw new FitConnectInitialisationException(e.getMessage(), e);
        }
    }

    public static SchemaResources loadAllSchemaResources(String schemaConfigName, Map<String, String> submissionDataSchemas) {
        SchemaResourceConfig schemaResourceConfig = ResourceLoadingUtils.loadYaml(schemaConfigName, SchemaResourceConfig.class);
        List<String> metadataSchemas = ResourceLoadingUtils.readSchemaResourcesFromPaths(schemaResourceConfig.getMetadataSchemaPaths());
        List<String> setSchemas = ResourceLoadingUtils.readSchemaResourcesFromPaths(schemaResourceConfig.getSetSchemaPaths());
        List<String> destinationSchemas = ResourceLoadingUtils.readSchemaResourcesFromPaths(List.of(schemaResourceConfig.getDestinationSchemaPath()));
        return new SchemaResources(setSchemas, metadataSchemas, destinationSchemas, submissionDataSchemas);
    }

    public static String readResourceToString(String resourcePath) {
        return new String(ResourceLoadingUtils.readResourceToByteArray(resourcePath), StandardCharsets.UTF_8);
    }

    private static byte[] readResourceToByteArray(String resourcePath) {
        byte[] byArray;
        block8: {
            InputStream in = ResourceLoadingUtils.class.getResourceAsStream(resourcePath);
            try {
                byArray = Objects.requireNonNull(in).readAllBytes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException exception) {
                    throw new FitConnectInitialisationException("Failed loading resource " + resourcePath, exception);
                }
            }
            in.close();
        }
        return byArray;
    }

    private static List<String> readSchemaResourcesFromPaths(List<String> schemaPaths) {
        return schemaPaths.stream().map(ResourceLoadingUtils::readResourceToByteArray).map(String::new).collect(Collectors.toList());
    }

    @Generated
    private ResourceLoadingUtils() {
    }
}

