/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import dev.fitko.fitconnect.api.domain.crypto.JWKPair;
import dev.fitko.fitconnect.core.crypto.utils.KeyGenerator;
import java.security.KeyPair;
import java.util.UUID;

public final class ReplyChannelKeyGenerator {
    private static final int DEFAULT_KEY_SIZE = 4096;
    private static final String KEY_ID_PREFIX = "reply-key:";

    private ReplyChannelKeyGenerator() {
    }

    public static JWKPair generateKeyPair() {
        return ReplyChannelKeyGenerator.generateKeyPair(UUID.randomUUID());
    }

    public static JWKPair generateKeyPair(UUID caseId) {
        String keyId = KEY_ID_PREFIX + String.valueOf(caseId);
        KeyPair keyPair = KeyGenerator.buildRSAKeyPair(4096);
        JWK publicEncryptionKey = KeyGenerator.buildJWK(keyPair, keyId, KeyOperation.WRAP_KEY, (Algorithm)JWEAlgorithm.RSA_OAEP_256);
        JWK privateDecryptionKey = KeyGenerator.buildJWK(keyPair, keyId, KeyOperation.UNWRAP_KEY, (Algorithm)JWEAlgorithm.RSA_OAEP_256);
        return new JWKPair(publicEncryptionKey.toPublicJWK(), privateDecryptionKey);
    }
}

