/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.metadata.v1.MetadataV1;
import dev.fitko.fitconnect.api.domain.model.metadata.v2.MetadataV2;
import java.io.IOException;

public final class MetadataDeserializationHelper {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    private MetadataDeserializationHelper() {
    }

    public static Metadata deserializeMetadata(ObjectMapper mapper, byte[] metadataBytes) throws IOException {
        String schemaUri;
        ObjectNode root = (ObjectNode)mapper.readTree(metadataBytes);
        String string = schemaUri = root.has("$schema") ? root.get("$schema").asText() : "";
        if (schemaUri.contains("/2.")) {
            return (Metadata)mapper.treeToValue((TreeNode)root, MetadataV2.class);
        }
        if (schemaUri.contains("/1.")) {
            return (Metadata)mapper.treeToValue((TreeNode)root, MetadataV1.class);
        }
        throw new IOException("Failed to deserialize metadata. Unknown metadata version: " + schemaUri);
    }

    public static Metadata deserializeMetadata(byte[] metadataBytes) throws IOException {
        return MetadataDeserializationHelper.deserializeMetadata(DEFAULT_MAPPER, metadataBytes);
    }
}

