/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import dev.fitko.fitconnect.api.config.Version;
import dev.fitko.fitconnect.api.config.defaults.SchemaConfig;
import dev.fitko.fitconnect.api.domain.model.attachment.AttachmentPayload;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.metadata.ContentStructure;
import dev.fitko.fitconnect.api.domain.model.metadata.Hash;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.metadata.SignatureType;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.ApiAttachment;
import dev.fitko.fitconnect.api.domain.model.metadata.data.Data;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import dev.fitko.fitconnect.api.domain.model.metadata.v1.MetadataV1;
import dev.fitko.fitconnect.api.domain.model.metadata.v2.MetadataV2;
import dev.fitko.fitconnect.api.domain.sender.SendableSubmission;
import dev.fitko.fitconnect.api.services.crypto.MessageDigestService;
import dev.fitko.fitconnect.client.util.AttachmentMapper;
import dev.fitko.fitconnect.core.crypto.HashService;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataBuilder.class);
    private static final MessageDigestService HASH_SERVICE = new HashService();

    private MetadataBuilder() {
    }

    public static Metadata createMetadata(SendableSubmission submission, PublicDestination destination, List<AttachmentPayload> uploadedAttachments) {
        Version version = MetadataBuilder.determineMetadataVersion(submission, destination);
        Metadata metadata = MetadataBuilder.createMetadataForVersion(version);
        metadata.setSchema(SchemaConfig.METADATA_SCHEMA_PATH.getSchemaUriForVersion(version).toString());
        byte[] dataHash = HASH_SERVICE.createHash(submission.getData());
        String dataHashHexString = HASH_SERVICE.toHexString(dataHash);
        List<ApiAttachment> apiAttachments = uploadedAttachments.stream().map(AttachmentMapper::toApiAttachment).collect(Collectors.toList());
        Data data = MetadataBuilder.createData(dataHashHexString, submission.getSubmissionSchema());
        ContentStructure contentStructure = new ContentStructure();
        contentStructure.setData(data);
        contentStructure.setAttachments(apiAttachments);
        metadata.setContentStructure(contentStructure);
        MetadataBuilder.setOptionalProperties(submission, metadata);
        return metadata;
    }

    public static Version determineMetadataVersion(SendableSubmission sendableSubmission, PublicDestination destination) {
        Version requestedVersion = sendableSubmission.getMetadataVersion().getLatestVersion();
        List<Version> supportedVersions = destination.getMetadataVersions().stream().map(Version::new).collect(Collectors.toList());
        return supportedVersions.stream().filter(version -> version.getMajor() == requestedVersion.getMajor()).max(Version::compareTo).orElseGet(MetadataBuilder.useFallBackVersion(supportedVersions));
    }

    private static Supplier<Version> useFallBackVersion(List<Version> supportedVersions) {
        return () -> {
            Version latestVersion = (Version)supportedVersions.stream().max(Version::compareTo).get();
            LOGGER.info("Requested metadata version is not available on destination, using latest supported version {}", (Object)latestVersion.getVersionAsString());
            return latestVersion;
        };
    }

    public static Metadata createMetadataForVersion(Version version) {
        if (version.getMajor() == 1) {
            return new MetadataV1();
        }
        if (version.getMajor() == 2) {
            return new MetadataV2();
        }
        throw new IllegalArgumentException("Unsupported metadata version: " + String.valueOf(version) + ". Supported versions are 1.x and 2.x");
    }

    private static Data createData(String hashedData, SubmissionSchema submissionSchema) {
        Hash hash = new Hash();
        hash.setContent(hashedData);
        hash.setSignatureType(SignatureType.SHA_512);
        Data data = new Data();
        data.setSubmissionSchema(submissionSchema);
        data.setHash(hash);
        return data;
    }

    private static void setOptionalProperties(SendableSubmission sendableSubmission, Metadata metadata) {
        MetadataBuilder.setCommonProperties(sendableSubmission, metadata);
        if (metadata instanceof MetadataV1) {
            MetadataBuilder.setMetadataV1Properties(sendableSubmission, (MetadataV1)metadata);
        } else if (metadata instanceof MetadataV2) {
            MetadataBuilder.setMetadataV2Properties(sendableSubmission, (MetadataV2)metadata);
        }
    }

    private static void setCommonProperties(SendableSubmission sendableSubmission, Metadata metadata) {
        if (sendableSubmission.getReplyChannel() != null) {
            metadata.setReplyChannel(sendableSubmission.getReplyChannel());
        }
        if (sendableSubmission.getPaymentInformation() != null) {
            metadata.setPaymentInformation(sendableSubmission.getPaymentInformation());
        }
        if (sendableSubmission.getAdditionalReferenceInfo() != null) {
            metadata.setAdditionalReferenceInfo(sendableSubmission.getAdditionalReferenceInfo());
        }
    }

    private static void setMetadataV1Properties(SendableSubmission sendableSubmission, MetadataV1 metadataV1) {
        if (sendableSubmission.getAuthenticationInformation() != null) {
            metadataV1.setAuthenticationInformation(sendableSubmission.getAuthenticationInformation());
        }
    }

    private static void setMetadataV2Properties(SendableSubmission sendableSubmission, MetadataV2 metadataV2) {
        if (sendableSubmission.getAuthor() != null) {
            metadataV2.setAuthor(sendableSubmission.getAuthor());
        }
        if (sendableSubmission.getDataSets() != null) {
            metadataV2.setDataSets(sendableSubmission.getDataSets());
        }
    }
}

