/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.virusscan.VirusScannerMode;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.api.exceptions.internal.VirusScanException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MalwareScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MalwareScanner.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final VirusScannerMode mode;
    private final FitConnectService service;

    public MalwareScanner(VirusScannerMode mode, FitConnectService service) {
        this.mode = mode;
        this.service = service;
    }

    public VirusScanResult scanMetadata(Metadata metadata) {
        if (this.mode.equals((Object)VirusScannerMode.NO_OP)) {
            return VirusScanResult.ofClean();
        }
        LOGGER.info("Scanning metadata for malware");
        try {
            byte[] metadataBytes = MAPPER.writeValueAsBytes((Object)metadata);
            return this.service.scanBytesForViruses(metadataBytes);
        }
        catch (JsonProcessingException e) {
            throw new VirusScanException("Failed to serialise metadata object: " + e.getMessage());
        }
    }

    public VirusScanResult scanData(byte[] data) {
        if (this.mode.equals((Object)VirusScannerMode.NO_OP)) {
            return VirusScanResult.ofClean();
        }
        LOGGER.info("Scanning data for malware");
        return this.service.scanBytesForViruses(data);
    }

    public VirusScanResult scanAttachments(List<Attachment> attachments) {
        if (this.mode.equals((Object)VirusScannerMode.NO_OP)) {
            return VirusScanResult.ofClean();
        }
        for (Attachment attachment : attachments) {
            LOGGER.info("Scanning attachment {} for malware", (Object)attachment.getAttachmentId());
            VirusScanResult attachmentScanResult = this.scanSingleAttachment(attachment);
            if (!attachmentScanResult.isInfected()) continue;
            return attachmentScanResult;
        }
        return VirusScanResult.ofClean();
    }

    private VirusScanResult scanSingleAttachment(Attachment attachment) {
        if (attachment.isLargeAttachment()) {
            return this.service.scanFileForViruses(attachment.getLargeAttachmentFilePath());
        }
        return this.service.scanBytesForViruses(attachment.getDataAsBytes());
    }
}

