/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.util;

import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.attachment.AttachmentPayload;
import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import dev.fitko.fitconnect.api.domain.model.metadata.Hash;
import dev.fitko.fitconnect.api.domain.model.metadata.SignatureType;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.ApiAttachment;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.AttachmentForValidation;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public final class AttachmentMapper {
    private AttachmentMapper() {
    }

    public static ApiAttachment toApiAttachment(AttachmentPayload attachmentPayload) {
        ApiAttachment attachment = new ApiAttachment();
        attachment.setAttachmentId(attachmentPayload.getAttachmentId());
        attachment.setPurpose(attachmentPayload.getPurpose());
        attachment.setFilename(attachmentPayload.getFileName());
        attachment.setMimeType(attachmentPayload.getMimeType());
        attachment.setDescription(attachmentPayload.getDescription());
        if (attachmentPayload.hasFragmentedPayload()) {
            attachment.setFragments(attachmentPayload.getFragmentIds());
        }
        Hash hash = new Hash();
        hash.setContent(attachmentPayload.getHashedData());
        hash.setSignatureType(SignatureType.SHA_512);
        attachment.setHash(hash);
        return attachment;
    }

    public static List<Attachment> getReceivedApiAttachments(List<AttachmentForValidation> attachments) {
        return attachments.stream().map(AttachmentMapper::toApiAttachment).filter(a -> !a.getPurpose().equals((Object)Purpose.DATA)).collect(Collectors.toList());
    }

    public static Attachment toApiAttachment(AttachmentForValidation attachment) {
        ApiAttachment metadata = attachment.getAttachmentMetadata();
        if (attachment.hasFragmentedPayload()) {
            return new Attachment(metadata.getAttachmentId(), null, attachment.getDataFile().toPath(), metadata.getMimeType(), metadata.getFilename(), metadata.getDescription(), metadata.getPurpose());
        }
        return new Attachment(metadata.getAttachmentId(), attachment.getDecryptedData(), null, metadata.getMimeType(), metadata.getFilename(), metadata.getDescription(), metadata.getPurpose());
    }

    public static Map<UUID, String> mapAttachmentIdsToAuthTags(List<AttachmentForValidation> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<UUID, String> attachmentAuthTags = new LinkedHashMap<UUID, String>();
        for (AttachmentForValidation attachment : attachments) {
            if (attachment.hasFragmentedPayload()) {
                attachmentAuthTags.putAll(attachment.getFragments().stream().collect(Collectors.toMap(Fragment::getFragmentId, Fragment::getAuthTag)));
                continue;
            }
            attachmentAuthTags.put(attachment.getAttachmentId(), attachment.getAuthTag());
        }
        return attachmentAuthTags;
    }

    public static Optional<byte[]> getSubmissionDataFromAttachments(List<AttachmentForValidation> attachments) throws IOException {
        Optional<AttachmentForValidation> submissionDataAsAttachment = attachments.stream().filter(AttachmentForValidation::isDataAttachment).findFirst();
        if (submissionDataAsAttachment.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(AttachmentMapper.getDataFromAttachment(submissionDataAsAttachment.get()));
    }

    private static byte[] getDataFromAttachment(AttachmentForValidation attachment) throws IOException {
        if (attachment.hasFragmentedPayload()) {
            Path path = attachment.getDataFile().toPath();
            byte[] data = Files.readAllBytes(path);
            path.toFile().delete();
            return data;
        }
        return attachment.getDecryptedData();
    }
}

