/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.subscriber;

import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.limits.Limit;
import dev.fitko.fitconnect.api.domain.limits.submission.SubmissionLimits;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.attachment.AttachmentPayload;
import dev.fitko.fitconnect.api.domain.model.cases.Case;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.metadata.ContentStructure;
import dev.fitko.fitconnect.api.domain.model.metadata.Hash;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.metadata.SignatureType;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import dev.fitko.fitconnect.api.domain.model.metadata.data.Data;
import dev.fitko.fitconnect.api.domain.model.metadata.data.MimeType;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import dev.fitko.fitconnect.api.domain.model.metadata.v1.MetadataV1;
import dev.fitko.fitconnect.api.domain.model.reply.AnnounceReply;
import dev.fitko.fitconnect.api.domain.model.reply.CreatedReply;
import dev.fitko.fitconnect.api.domain.model.reply.SentReply;
import dev.fitko.fitconnect.api.domain.model.reply.SubmitReply;
import dev.fitko.fitconnect.api.domain.subscriber.SendableReply;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectReplyException;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import dev.fitko.fitconnect.client.attachments.upload.AttachmentUploader;
import dev.fitko.fitconnect.client.util.AttachmentMapper;
import dev.fitko.fitconnect.client.util.MalwareScanner;
import dev.fitko.fitconnect.client.util.SubmissionValidator;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplySender {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplySender.class);
    private final ApplicationConfig config;
    private final FitConnectService fitConnectService;
    private final SubmissionValidator submissionValidator;
    private final AttachmentPayloadHandler attachmentPayloadHandler;
    private final AttachmentUploader attachmentUploader;
    private final MalwareScanner malwareScanner;

    public ReplySender(ApplicationConfig config, FitConnectService fitConnectService, SubmissionValidator submissionValidator, AttachmentPayloadHandler attachmentPayloadHandler, AttachmentUploader attachmentUploader) {
        this.config = config;
        this.fitConnectService = fitConnectService;
        this.submissionValidator = submissionValidator;
        this.attachmentPayloadHandler = attachmentPayloadHandler;
        this.attachmentUploader = attachmentUploader;
        this.malwareScanner = new MalwareScanner(config.getVirusScannerMode(), fitConnectService);
    }

    public SentReply sendReply(SendableReply sendableReply) {
        LOGGER.debug("Scanning data and attachments for malware");
        this.scanForMalware(sendableReply);
        Case replyCase = this.fitConnectService.getCase(sendableReply.getCaseId());
        PublicDestination destination = this.fitConnectService.getPublicDestination(replyCase.getDestinationId());
        this.submissionValidator.ensureValidDataPayload(sendableReply, destination);
        List<AttachmentPayload> attachmentPayloads = this.createAttachmentPayloads(sendableReply, destination);
        LOGGER.info("Reply is being created");
        List<UUID> attachmentIdsToBeAnnounced = ReplySender.getAttachmentIdsToBeAnnounced(attachmentPayloads);
        AnnounceReply announceReply = new AnnounceReply(sendableReply.getCaseId(), attachmentIdsToBeAnnounced);
        CreatedReply createdReply = this.fitConnectService.announceReply(announceReply);
        RSAKey replyEncryptionKey = sendableReply.getReplyEncryptionKey().toRSAKey();
        LOGGER.info("Uploading {} reply attachment(s)", (Object)attachmentPayloads.size());
        List<AttachmentPayload> uploadedAttachments = this.attachmentUploader.uploadAttachments(attachmentPayloads, createdReply.getReplyId(), replyEncryptionKey);
        LOGGER.info("Creating metadata");
        Metadata metadata = this.createMetadata(sendableReply, uploadedAttachments);
        ValidationResult validatedMetadata = this.fitConnectService.validateMetadataSchema(metadata);
        if (validatedMetadata.hasError()) {
            LOGGER.error("Metadata does not match schema", (Throwable)validatedMetadata.getError());
            throw new FitConnectReplyException(validatedMetadata.getError().getMessage(), validatedMetadata.getError());
        }
        LOGGER.info("Encrypting reply data");
        String replyDataMimeType = sendableReply.getDataMimeType().value();
        String encryptedData = this.fitConnectService.encryptBytes(replyEncryptionKey, sendableReply.getData(), replyDataMimeType);
        LOGGER.info("Encrypting reply metadata");
        String encryptedMetadata = this.fitConnectService.encryptObject(replyEncryptionKey, metadata, MimeType.APPLICATION_JSON.value());
        SentReply sentReply = this.fitConnectService.submitReply(createdReply.getReplyId(), new SubmitReply(encryptedData, encryptedMetadata));
        LOGGER.info("SUCCESSFULLY SENT REPLY ! \n");
        return sentReply;
    }

    private List<AttachmentPayload> createAttachmentPayloads(SendableReply sendableReply, PublicDestination destination) {
        List<Attachment> attachments = sendableReply.getAttachments();
        if (attachments.stream().anyMatch(a -> a.getPurpose().equals((Object)Purpose.DATA))) {
            LOGGER.info("Reply data exceeds allowed limit and will be sent as attachment");
        }
        if (this.submissionValidator.destinationSupportsAttachmentChunking(destination, attachments, this.config.getAttachmentChunkingConfig())) {
            SubmissionLimits caseAttachmentLimits = this.fitConnectService.getCaseAttachmentLimits(sendableReply.getCaseId());
            Limit replyAttachmentLimit = caseAttachmentLimits.getAttachments().getReplyLimits().getApplicable();
            return this.attachmentPayloadHandler.createChunkedPayloads(attachments, replyAttachmentLimit);
        }
        return this.attachmentPayloadHandler.createPayloadsWithoutChunking(attachments);
    }

    private Metadata createMetadata(SendableReply sendableReply, List<AttachmentPayload> attachments) {
        Hash hash = new Hash();
        hash.setContent(this.fitConnectService.createHash(sendableReply.getData()));
        hash.setSignatureType(SignatureType.SHA_512);
        SubmissionSchema submissionSchema = new SubmissionSchema(sendableReply.getSchemaUri(), sendableReply.getDataMimeType());
        Data data = new Data();
        data.setSubmissionSchema(submissionSchema);
        data.setHash(hash);
        ContentStructure contentStructure = new ContentStructure();
        contentStructure.setAttachments(attachments.stream().map(AttachmentMapper::toApiAttachment).collect(Collectors.toList()));
        contentStructure.setData(data);
        MetadataV1 metadata = new MetadataV1();
        metadata.setSchema(this.config.getMetadataSchemaWriteVersion().toString());
        metadata.setContentStructure(contentStructure);
        this.scanForMalware(metadata);
        return metadata;
    }

    private static List<UUID> getAttachmentIdsToBeAnnounced(List<AttachmentPayload> attachmentPayloads) {
        return attachmentPayloads.stream().map(AttachmentPayload::getAllAttachmentIds).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void scanForMalware(SendableReply sendableReply) {
        VirusScanResult dataScanResult = this.malwareScanner.scanData(sendableReply.getData());
        if (dataScanResult.isInfected()) {
            LOGGER.error("Data is infected with {}", (Object)dataScanResult.getSignature());
            throw new FitConnectReplyException("Data is infected with virus: " + dataScanResult.getSignature());
        }
        VirusScanResult attachmentsScanResult = this.malwareScanner.scanAttachments(sendableReply.getAttachments());
        if (attachmentsScanResult.isInfected()) {
            LOGGER.error("Attachment is infected with virus {}", (Object)attachmentsScanResult.getResult());
            throw new FitConnectReplyException("Attachment " + attachmentsScanResult.getResult() + " is infected with virus: " + attachmentsScanResult.getSignature());
        }
    }

    private void scanForMalware(Metadata metadata) {
        VirusScanResult dataScanResult = this.malwareScanner.scanMetadata(metadata);
        if (dataScanResult.isInfected()) {
            LOGGER.error("Metadata is infected with {}", (Object)dataScanResult.getSignature());
            throw new FitConnectReplyException("Metadata is infected with virus: " + dataScanResult.getSignature());
        }
    }
}

