/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.bootstrap;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.config.SenderConfig;
import dev.fitko.fitconnect.api.config.SubscriberConfig;
import dev.fitko.fitconnect.api.config.ZBPCertConfig;
import dev.fitko.fitconnect.api.config.chunking.AttachmentChunkingConfig;
import dev.fitko.fitconnect.api.config.defaults.ZBPEnvironment;
import dev.fitko.fitconnect.api.config.http.HttpConfig;
import dev.fitko.fitconnect.api.config.http.RetryConfig;
import dev.fitko.fitconnect.api.config.resources.BuildInfo;
import dev.fitko.fitconnect.api.config.resources.CertificateConfig;
import dev.fitko.fitconnect.api.domain.schema.SchemaResources;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectInitialisationException;
import dev.fitko.fitconnect.api.services.crypto.MessageDigestService;
import dev.fitko.fitconnect.api.services.http.HttpClient;
import dev.fitko.fitconnect.api.services.schema.SchemaProvider;
import dev.fitko.fitconnect.api.services.validation.ValidationService;
import dev.fitko.fitconnect.api.services.validation.VirusScanService;
import dev.fitko.fitconnect.client.DestinationClient;
import dev.fitko.fitconnect.client.RouterClient;
import dev.fitko.fitconnect.client.SenderClient;
import dev.fitko.fitconnect.client.SubscriberClient;
import dev.fitko.fitconnect.client.ZBPClient;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import dev.fitko.fitconnect.client.attachments.AttachmentStorageResolver;
import dev.fitko.fitconnect.client.attachments.ConcurrencyLimiter;
import dev.fitko.fitconnect.client.attachments.download.ReplyAttachmentDownloader;
import dev.fitko.fitconnect.client.attachments.download.SubmissionAttachmentDownloader;
import dev.fitko.fitconnect.client.attachments.upload.ReplyAttachmentUploader;
import dev.fitko.fitconnect.client.attachments.upload.SubmissionAttachmentUploader;
import dev.fitko.fitconnect.client.sender.ReplyReceiver;
import dev.fitko.fitconnect.client.sender.SubmissionSender;
import dev.fitko.fitconnect.client.subscriber.ReplySender;
import dev.fitko.fitconnect.client.subscriber.SubmissionReceiver;
import dev.fitko.fitconnect.client.util.ResourceLoadingUtils;
import dev.fitko.fitconnect.client.util.SubmissionValidator;
import dev.fitko.fitconnect.client.zbp.ZBPServiceAdapter;
import dev.fitko.fitconnect.core.FitConnectDefaultService;
import dev.fitko.fitconnect.core.auth.DefaultOAuthApiService;
import dev.fitko.fitconnect.core.cases.CaseApiService;
import dev.fitko.fitconnect.core.cases.EventLogVerifier;
import dev.fitko.fitconnect.core.cases.SecurityEventTokenService;
import dev.fitko.fitconnect.core.crypto.HashService;
import dev.fitko.fitconnect.core.crypto.JWECryptoService;
import dev.fitko.fitconnect.core.destination.DestinationApiService;
import dev.fitko.fitconnect.core.http.DefaultHttpClient;
import dev.fitko.fitconnect.core.http.interceptors.ApiRequestInterceptor;
import dev.fitko.fitconnect.core.http.interceptors.RetryInterceptor;
import dev.fitko.fitconnect.core.http.interceptors.UserAgentInterceptor;
import dev.fitko.fitconnect.core.io.FileChunker;
import dev.fitko.fitconnect.core.keys.PublicKeyApiService;
import dev.fitko.fitconnect.core.reply.ReplyApiService;
import dev.fitko.fitconnect.core.routing.RouteVerifier;
import dev.fitko.fitconnect.core.routing.RoutingApiService;
import dev.fitko.fitconnect.core.schema.SchemaResourceProvider;
import dev.fitko.fitconnect.core.submission.SubmissionApiService;
import dev.fitko.fitconnect.core.validation.DefaultValidationService;
import dev.fitko.fitconnect.core.validation.virusscan.VirusScannerFactory;
import dev.fitko.fitconnect.core.validation.xml.XRepoSchemaLoader;
import dev.fitko.fitconnect.core.validation.xml.XmlSchemaValidator;
import dev.fitko.fitconnect.core.zbp.ZBPApiService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientFactory.class);
    private static final String BUILD_INFO_PATH = "buildinfo.yaml";
    private static final String CERTIFICATE_CONFIG_PATH = "certificate-config.yaml";
    private static final String SCHEMA_CONFIG_PATH = "schema-config.yaml";

    private ClientFactory() {
    }

    public static SenderClient createSenderClient(ApplicationConfig config) throws FitConnectInitialisationException {
        Objects.requireNonNull(config, "Application config must not be null");
        LOGGER.info("Initializing sender client ...");
        SenderConfig senderConfig = config.getSenderConfig();
        FitConnectService fitConnectService = ClientFactory.createFitConnectService(config, senderConfig.getClientId(), senderConfig.getClientSecret());
        SubmissionValidator submissionValidator = new SubmissionValidator(fitConnectService);
        AttachmentChunkingConfig chunkingConfig = config.getAttachmentChunkingConfig();
        AttachmentStorageResolver attachmentStorageResolver = new AttachmentStorageResolver(chunkingConfig.getAttachmentStoragePath());
        AttachmentPayloadHandler attachmentPayloadHandler = ClientFactory.createPayloadHandler(chunkingConfig, attachmentStorageResolver);
        SubmissionAttachmentUploader attachmentUploader = new SubmissionAttachmentUploader(fitConnectService);
        ReplyAttachmentDownloader attachmentDownloader = new ReplyAttachmentDownloader(config, fitConnectService, attachmentPayloadHandler);
        SubmissionSender submissionSender = new SubmissionSender(config, fitConnectService, submissionValidator, attachmentPayloadHandler, attachmentUploader);
        ReplyReceiver replyReceiver = new ReplyReceiver(config, fitConnectService, attachmentDownloader);
        return new SenderClient(fitConnectService, submissionSender, replyReceiver, attachmentStorageResolver);
    }

    public static SubscriberClient createSubscriberClient(ApplicationConfig config) throws FitConnectInitialisationException {
        Objects.requireNonNull(config, "Application config must not be null");
        LOGGER.info("Initializing subscriber client ...");
        SubscriberConfig subscriberConfig = config.getSubscriberConfig();
        RSAKey rsaDecryptionKey = ClientFactory.getDecryptionKeyFromConfig(subscriberConfig);
        RSAKey rsaSigningKey = ClientFactory.getSignatureKeyFromConfig(subscriberConfig);
        FitConnectService fitConnectService = ClientFactory.createFitConnectService(config, subscriberConfig.getClientId(), subscriberConfig.getClientSecret(), rsaSigningKey);
        SubmissionValidator submissionValidator = new SubmissionValidator(fitConnectService);
        AttachmentChunkingConfig chunkingConfig = config.getAttachmentChunkingConfig();
        AttachmentStorageResolver attachmentStorageResolver = new AttachmentStorageResolver(chunkingConfig.getAttachmentStoragePath());
        AttachmentPayloadHandler attachmentPayloadHandler = ClientFactory.createPayloadHandler(chunkingConfig, attachmentStorageResolver);
        ReplyAttachmentUploader attachmentUploader = new ReplyAttachmentUploader(fitConnectService);
        SubmissionAttachmentDownloader attachmentDownloader = new SubmissionAttachmentDownloader(config, fitConnectService, attachmentPayloadHandler);
        SubmissionReceiver submissionReceiver = new SubmissionReceiver(fitConnectService, rsaDecryptionKey, config, attachmentDownloader);
        ReplySender replySender = new ReplySender(config, fitConnectService, submissionValidator, attachmentPayloadHandler, attachmentUploader);
        return new SubscriberClient(fitConnectService, submissionReceiver, replySender, attachmentStorageResolver);
    }

    public static RouterClient createRouterClient(ApplicationConfig config) throws FitConnectInitialisationException {
        Objects.requireNonNull(config, "Application config must not be null");
        LOGGER.info("Initializing router client ...");
        HttpClient httpClient = ClientFactory.createHttpClient(config);
        SchemaProvider schemaProvider = ClientFactory.createSchemaProvider(httpClient, config);
        ValidationService validator = ClientFactory.createValidationService(config, schemaProvider, new HashService(), httpClient);
        PublicKeyApiService keyService = new PublicKeyApiService(config, httpClient, validator);
        RouteVerifier routeVerifier = new RouteVerifier(keyService, validator);
        RoutingApiService routingService = new RoutingApiService(httpClient, config.getRoutingBaseUrl());
        return new RouterClient(routingService, routeVerifier);
    }

    public static DestinationClient createDestinationClient(ApplicationConfig config) throws FitConnectInitialisationException {
        Objects.requireNonNull(config, "Application config must not be null");
        Objects.requireNonNull(config.getSubscriberConfig(), "DestinationClient requires a subscriber config, but was null");
        LOGGER.info("Initializing destination client ...");
        SubscriberConfig subscriberConfig = config.getSubscriberConfig();
        String clientId = subscriberConfig.getClientId();
        String clientSecret = subscriberConfig.getClientSecret();
        HttpClient httpClient = ClientFactory.createHttpClient(config);
        DefaultOAuthApiService authService = new DefaultOAuthApiService(httpClient, clientId, clientSecret, config.getAuthBaseUrl());
        DestinationApiService destinationApiService = new DestinationApiService(authService, httpClient, config.getDestinationBaseUrl());
        return new DestinationClient(destinationApiService);
    }

    public static ZBPClient createZBPClient(ZBPCertConfig certConfig, ZBPEnvironment environment) {
        return ClientFactory.createZBPClient(certConfig, environment, HttpConfig.builder().build());
    }

    public static ZBPClient createZBPClient(ZBPCertConfig certConfig, ZBPEnvironment environment, HttpConfig httpConfig) {
        LOGGER.info("Initializing ZBP client ...");
        ApplicationConfig config = ApplicationConfig.builder().httpConfig(httpConfig).build();
        HttpClient httpClient = ClientFactory.createHttpClient(config, certConfig, environment);
        ZBPApiService apiService = new ZBPApiService(httpClient, environment, certConfig);
        return new ZBPClient(new ZBPServiceAdapter(apiService, certConfig));
    }

    private static FitConnectService createFitConnectService(ApplicationConfig config, String clientId, String clientSecret) {
        return ClientFactory.createFitConnectService(config, clientId, clientSecret, null);
    }

    private static FitConnectService createFitConnectService(ApplicationConfig config, String clientId, String clientSecret, RSAKey signingKey) {
        HttpClient httpClient = ClientFactory.createHttpClient(config);
        SchemaProvider schemaProvider = ClientFactory.createSchemaProvider(httpClient, config);
        HashService messageDigestService = new HashService();
        JWECryptoService cryptoService = new JWECryptoService(messageDigestService);
        ValidationService validator = ClientFactory.createValidationService(config, schemaProvider, messageDigestService, httpClient);
        DefaultOAuthApiService authService = new DefaultOAuthApiService(httpClient, clientId, clientSecret, config.getAuthBaseUrl());
        SubmissionApiService submissionService = new SubmissionApiService(authService, httpClient, config.getSubmissionBaseUrl());
        DestinationApiService destinationService = new DestinationApiService(authService, httpClient, config.getDestinationBaseUrl());
        PublicKeyApiService keyService = new PublicKeyApiService(config, httpClient, authService, validator);
        EventLogVerifier eventLogVerifier = new EventLogVerifier(keyService, validator);
        CaseApiService caseService = new CaseApiService(authService, httpClient, eventLogVerifier, config.getSubmissionBaseUrl());
        ReplyApiService replyService = new ReplyApiService(authService, httpClient, config.getSubmissionBaseUrl());
        SecurityEventTokenService setService = new SecurityEventTokenService(config, validator, signingKey);
        ConcurrencyLimiter concurrencyLimiter = new ConcurrencyLimiter(config.getConcurrentAttachmentStreams());
        VirusScanService virusScanner = VirusScannerFactory.createScanner(config.getVirusScannerMode(), config.getVirusScannerConfig());
        return FitConnectDefaultService.builder().submissionService(submissionService).destinationService(destinationService).caseService(caseService).replyService(replyService).cryptoService(cryptoService).validationService(validator).keyService(keyService).securityEventService(setService).concurrencyLimiter(concurrencyLimiter).virusScanService(virusScanner).build();
    }

    private static ValidationService createValidationService(ApplicationConfig config, SchemaProvider schemaProvider, MessageDigestService messageDigestService, HttpClient httpClient) {
        List<String> trustedRootCertificates = ResourceLoadingUtils.loadYaml(CERTIFICATE_CONFIG_PATH, CertificateConfig.class).getTrustedRootCertificates().stream().map(ResourceLoadingUtils::readResourceToString).collect(Collectors.toList());
        LOGGER.info("Initialised trusted root certificates");
        XmlSchemaValidator xmlSchemaValidator = ClientFactory.createXmlSchemaValidator(httpClient);
        return new DefaultValidationService(config, messageDigestService, schemaProvider, xmlSchemaValidator, trustedRootCertificates);
    }

    private static XmlSchemaValidator createXmlSchemaValidator(HttpClient httpClient) {
        XRepoSchemaLoader schemaLoader = new XRepoSchemaLoader(httpClient);
        return new XmlSchemaValidator(schemaLoader);
    }

    private static HttpClient createHttpClient(ApplicationConfig config) {
        return ClientFactory.createHttpClient(config, null, null);
    }

    private static HttpClient createHttpClient(ApplicationConfig config, ZBPCertConfig zbpCertConfig, ZBPEnvironment zbpEnvironment) {
        BuildInfo buildInfo = ResourceLoadingUtils.loadYaml(BUILD_INFO_PATH, BuildInfo.class);
        HttpConfig httpConfig = config.getHttpConfig();
        List<Interceptor> interceptors = ClientFactory.getInterceptors(buildInfo, httpConfig);
        return new DefaultHttpClient(httpConfig, interceptors, zbpCertConfig, zbpEnvironment);
    }

    private static List<Interceptor> getInterceptors(BuildInfo buildInfo, HttpConfig httpConfig) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.add(new ApiRequestInterceptor());
        interceptors.add(new UserAgentInterceptor(buildInfo));
        RetryConfig retryConfig = httpConfig.getRetryConfig();
        if (retryConfig.isAllowRetries()) {
            LOGGER.info("Using {} retries for failed HTTP-calls", (Object)retryConfig.getMaxRetryCount());
            interceptors.add(new RetryInterceptor(retryConfig));
        }
        return interceptors;
    }

    private static SchemaProvider createSchemaProvider(HttpClient httpClient, ApplicationConfig config) {
        SchemaResources schemaResources = ResourceLoadingUtils.loadAllSchemaResources(SCHEMA_CONFIG_PATH, config.getSubmissionDataSchemas());
        return new SchemaResourceProvider(httpClient, schemaResources);
    }

    private static AttachmentPayloadHandler createPayloadHandler(AttachmentChunkingConfig config, AttachmentStorageResolver attachmentStorageResolver) {
        FileChunker fileChunker = new FileChunker();
        HashService messageDigestService = new HashService();
        return new AttachmentPayloadHandler(config, fileChunker, attachmentStorageResolver, messageDigestService);
    }

    private static RSAKey parseRSAKeyFromString(String key) {
        try {
            return RSAKey.parse((Map)JWK.parse((String)key).toJSONObject());
        }
        catch (NullPointerException | ParseException e) {
            LOGGER.error("Could not parse key, please check environment (config.yml)");
            throw new FitConnectInitialisationException("Key could not be parsed", e);
        }
    }

    private static String getPrivateDecryptionKeyPathFromSubscriber(SubscriberConfig subscriberConfig) {
        if (subscriberConfig.getPrivateDecryptionKeyPaths().size() != 1) {
            throw new FitConnectInitialisationException("Currently only one configured private key per subscriber is allowed !");
        }
        return subscriberConfig.getPrivateDecryptionKeyPaths().get(0);
    }

    private static RSAKey getSignatureKeyFromConfig(SubscriberConfig config) {
        LOGGER.info("Initialising private signature key");
        if (config.getSubscriberKeys() != null) {
            return config.getSubscriberKeys().getPrivateSigningKey().toRSAKey();
        }
        return ClientFactory.parseRSAKeyFromString(ResourceLoadingUtils.readKeyFromPath(config.getPrivateSigningKeyPath()));
    }

    private static RSAKey getDecryptionKeyFromConfig(SubscriberConfig config) {
        LOGGER.info("Initialising private decryption key");
        if (config.getSubscriberKeys() != null) {
            return config.getSubscriberKeys().getPrivateDecryptionKeys().get(0).toRSAKey();
        }
        String decryptionKeyPath = ClientFactory.getPrivateDecryptionKeyPathFromSubscriber(config);
        String decryptionKey = ResourceLoadingUtils.readKeyFromPath(decryptionKeyPath);
        return ClientFactory.parseRSAKeyFromString(decryptionKey);
    }
}

