/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.bootstrap;

import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.config.Environment;
import dev.fitko.fitconnect.api.config.EnvironmentName;
import dev.fitko.fitconnect.api.config.defaults.Environments;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectInitialisationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;

public final class ApplicationConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationConfigLoader.class);
    private static final String CONFIG_ENV_KEY_NAME = "FIT_CONNECT_CONFIG";

    private ApplicationConfigLoader() {
    }

    public static ApplicationConfig loadConfigFromPath(Path configPath) {
        try {
            return ApplicationConfigLoader.loadConfigFromYamlString(Files.readString(configPath));
        }
        catch (IOException | NullPointerException | YAMLException e) {
            LOGGER.error("config file could not be loaded from path {}", (Object)configPath);
            throw new FitConnectInitialisationException(e.getMessage(), e);
        }
    }

    public static ApplicationConfig loadConfigFromEnvironment() {
        Path configPath = ApplicationConfigLoader.getPathFromEnvironment();
        return ApplicationConfigLoader.loadConfigFromPath(configPath);
    }

    public static ApplicationConfig loadConfigFromYamlString(String configYaml) {
        return ApplicationConfigLoader.mergeConfigEnvironmentsWithSdkDefaults((ApplicationConfig)ApplicationConfigLoader.initNewYaml().loadAs(configYaml, ApplicationConfig.class));
    }

    private static ApplicationConfig mergeConfigEnvironmentsWithSdkDefaults(ApplicationConfig config) {
        Map<EnvironmentName, Environment> sdkEnvironments = Environments.getEnvironmentsAsMap();
        config.getEnvironments().forEach((key, value) -> {
            if (sdkEnvironments.containsKey(key)) {
                sdkEnvironments.put((EnvironmentName)key, value.merge((Environment)sdkEnvironments.get(key)));
            } else {
                sdkEnvironments.put((EnvironmentName)key, (Environment)value);
            }
        });
        return config.withEnvironments(sdkEnvironments);
    }

    private static Path getPathFromEnvironment() {
        try {
            return Path.of(System.getenv(CONFIG_ENV_KEY_NAME), new String[0]);
        }
        catch (NullPointerException | InvalidPathException e) {
            LOGGER.warn("Environment variable {} could not be loaded", (Object)CONFIG_ENV_KEY_NAME);
            throw new FitConnectInitialisationException(e.getMessage(), e);
        }
    }

    private static Yaml initNewYaml() {
        Yaml yaml = new Yaml();
        yaml.setBeanAccess(BeanAccess.FIELD);
        return yaml;
    }
}

