/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.attachments.upload;

import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.model.attachment.AttachmentPayload;
import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentUploader.class);
    protected final FitConnectService fitConnectService;

    protected AttachmentUploader(FitConnectService fitConnectService) {
        this.fitConnectService = fitConnectService;
    }

    public List<AttachmentPayload> uploadAttachments(List<AttachmentPayload> attachmentPayloads, UUID transmissionId, RSAKey encryptionKey) {
        if (attachmentPayloads.isEmpty()) {
            LOGGER.info("No attachments to upload");
            return attachmentPayloads;
        }
        LOGGER.info("Uploading {} attachment(s)", (Object)attachmentPayloads.size());
        ArrayList<AttachmentPayload> uploadedAttachments = new ArrayList<AttachmentPayload>();
        attachmentPayloads.forEach(attachment -> {
            if (attachment.hasFragmentedPayload()) {
                uploadedAttachments.add(this.uploadFragments(transmissionId, encryptionKey, (AttachmentPayload)attachment));
            } else {
                uploadedAttachments.add(this.uploadSingleAttachment(transmissionId, encryptionKey, (AttachmentPayload)attachment));
            }
        });
        return uploadedAttachments;
    }

    private AttachmentPayload uploadSingleAttachment(UUID transmissionId, RSAKey encryptionKey, AttachmentPayload attachment) {
        String encryptedData = this.fitConnectService.encryptBytes(encryptionKey, attachment.getData(), attachment.getMimeType());
        String hashedData = this.fitConnectService.createHash(attachment.getData());
        this.upload(transmissionId, attachment.getAttachmentId(), encryptedData);
        return attachment.withHashedData(hashedData).withAuthTag(AuthenticationTags.getAuthTagFromJWT(encryptedData));
    }

    private AttachmentPayload uploadFragments(UUID transmissionId, RSAKey encryptionKey, AttachmentPayload attachment) {
        LOGGER.info("Uploading {} fragments for attachment {}", (Object)attachment.getFragments().size(), (Object)attachment.getAttachmentId());
        for (Fragment fragment : attachment.getFragments()) {
            this.uploadSingleFragment(transmissionId, encryptionKey, attachment.getMimeType(), fragment);
        }
        attachment.getFragmentsBaseFolder().ifPresent(File::delete);
        return attachment;
    }

    private void uploadSingleFragment(UUID transmissionId, RSAKey encryptionKey, String mimeType, Fragment fragment) {
        try (FileInputStream is = new FileInputStream(fragment.getFile());){
            JWEObject encryptedData = this.fitConnectService.encryptInputStream(encryptionKey, is, mimeType);
            this.upload(transmissionId, fragment.getFragmentId(), encryptedData.serialize());
            fragment.setAuthTag(encryptedData.getAuthTag().toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            fragment.getFile().delete();
        }
    }

    protected abstract void upload(UUID var1, UUID var2, String var3);
}

