/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.attachments.download;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.MissingAttachment;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.exceptions.internal.SubmissionRequestException;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import dev.fitko.fitconnect.client.attachments.download.AttachmentDownloader;
import java.util.List;
import java.util.UUID;

public class SubmissionAttachmentDownloader
extends AttachmentDownloader<Submission> {
    private final ApplicationConfig config;

    public SubmissionAttachmentDownloader(ApplicationConfig config, FitConnectService fitConnectService, AttachmentPayloadHandler attachmentPayloadHandler) {
        super(fitConnectService, attachmentPayloadHandler);
        this.config = config;
    }

    @Override
    protected String downloadAttachment(Submission submission, UUID attachmentId) {
        try {
            return this.fitConnectService.getSubmissionAttachment(submission.getSubmissionId(), attachmentId);
        }
        catch (RestApiException e) {
            if (e.isNotFound()) {
                this.reject(submission, (Problem)new MissingAttachment(attachmentId));
            }
            throw new SubmissionRequestException(e.getMessage(), e);
        }
    }

    @Override
    protected void reject(Submission submission, Problem problem) {
        if (this.config.isAutoRejectEnabled()) {
            LOGGER.info("Auto-rejecting submission due the following problem: {}", (Object)problem.getDetail());
            this.fitConnectService.rejectSubmission(EventPayload.forRejectEvent(submission, List.of(problem)));
        }
    }
}

