/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.attachments.download;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.config.ApplicationConfig;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.MissingAttachment;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectReplyException;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import dev.fitko.fitconnect.client.attachments.download.AttachmentDownloader;
import java.util.List;
import java.util.UUID;

public class ReplyAttachmentDownloader
extends AttachmentDownloader<Reply> {
    private final ApplicationConfig config;

    public ReplyAttachmentDownloader(ApplicationConfig config, FitConnectService fitConnectService, AttachmentPayloadHandler attachmentPayloadHandler) {
        super(fitConnectService, attachmentPayloadHandler);
        this.config = config;
    }

    @Override
    protected String downloadAttachment(Reply reply, UUID attachmentId) {
        try {
            return this.fitConnectService.getReplyAttachment(reply.getReplyId(), attachmentId);
        }
        catch (RestApiException e) {
            if (e.isNotFound()) {
                this.reject(reply, (Problem)new MissingAttachment(attachmentId));
            }
            throw new FitConnectReplyException(e.getMessage(), e);
        }
    }

    @Override
    protected void reject(Reply reply, Problem problem) {
        if (this.config.isAutoRejectEnabled()) {
            LOGGER.info("Auto-rejecting reply due the following problem: {}", (Object)problem.getDetail());
            this.fitConnectService.rejectReply(reply.getReplyId(), List.of(problem));
        }
    }
}

