/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.attachments.download;

import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.event.problems.attachment.AttachmentEncryptionIssue;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.ApiAttachment;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.AttachmentForValidation;
import dev.fitko.fitconnect.api.exceptions.internal.DecryptionException;
import dev.fitko.fitconnect.api.exceptions.internal.SubmissionRequestException;
import dev.fitko.fitconnect.client.attachments.AttachmentPayloadHandler;
import dev.fitko.fitconnect.core.utils.StopWatch;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentDownloader<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AttachmentDownloader.class);
    protected final FitConnectService fitConnectService;
    private final AttachmentPayloadHandler attachmentPayloadHandler;

    protected AttachmentDownloader(FitConnectService fitConnectService, AttachmentPayloadHandler attachmentPayloadHandler) {
        this.fitConnectService = fitConnectService;
        this.attachmentPayloadHandler = attachmentPayloadHandler;
    }

    public List<AttachmentForValidation> loadAttachments(T transmission, RSAKey privateDecryptionKey, List<ApiAttachment> apiAttachments) {
        if (apiAttachments == null || apiAttachments.isEmpty()) {
            LOGGER.info("Submission contains no attachments");
            return Collections.emptyList();
        }
        ArrayList<AttachmentForValidation> receivedAttachments = new ArrayList<AttachmentForValidation>();
        for (ApiAttachment apiAttachment : apiAttachments) {
            if (apiAttachment.hasFragments()) {
                receivedAttachments.add(this.loadFragmentedAttachment(transmission, privateDecryptionKey, apiAttachment));
                continue;
            }
            receivedAttachments.add(this.loadAttachmentWithoutFragments(transmission, privateDecryptionKey, apiAttachment));
        }
        return receivedAttachments;
    }

    private AttachmentForValidation loadFragmentedAttachment(T transmission, RSAKey privateDecryptionKey, ApiAttachment apiAttachment) {
        List<Fragment> fragments = this.downloadFragments(transmission, privateDecryptionKey, apiAttachment);
        Optional<File> mergedFile = this.attachmentPayloadHandler.mergeChunks(apiAttachment);
        return AttachmentForValidation.forFragmentedAttachment(apiAttachment, fragments, mergedFile.orElse(null));
    }

    private AttachmentForValidation loadAttachmentWithoutFragments(T transmission, RSAKey privateDecryptionKey, ApiAttachment apiAttachment) {
        UUID attachmentId = apiAttachment.getAttachmentId();
        String encryptedAttachment = this.downloadAttachment(transmission, attachmentId);
        byte[] decryptedAttachment = this.decryptAttachment(privateDecryptionKey, attachmentId, encryptedAttachment, transmission);
        String authTag = AuthenticationTags.getAuthTagFromJWT(encryptedAttachment);
        return AttachmentForValidation.forAttachmentWithoutFragments(apiAttachment, decryptedAttachment, authTag);
    }

    private List<Fragment> downloadFragments(T transmission, RSAKey privateDecryptionKey, ApiAttachment apiAttachment) {
        ArrayList<Fragment> downloadedFragments = new ArrayList<Fragment>();
        List<UUID> fragments = apiAttachment.getFragments();
        IntStream.range(0, fragments.size()).forEachOrdered(index -> {
            UUID fragmentId = (UUID)fragments.get(index);
            UUID attachmentId = apiAttachment.getAttachmentId();
            downloadedFragments.add(this.downloadFragment(transmission, privateDecryptionKey, attachmentId, fragmentId, index));
        });
        return downloadedFragments;
    }

    private Fragment downloadFragment(T transmission, RSAKey privateDecryptionKey, UUID parentAttachmentId, UUID fragmentId, int fragmentIndex) {
        String encryptedAttachment = this.downloadAttachment(transmission, fragmentId);
        byte[] decryptedAttachment = this.decryptAttachment(privateDecryptionKey, fragmentId, encryptedAttachment, transmission);
        String authTag = AuthenticationTags.getAuthTagFromJWT(encryptedAttachment);
        File file = this.attachmentPayloadHandler.writeReceivedFragmentToFileSystem(parentAttachmentId, fragmentIndex, decryptedAttachment);
        return new Fragment(fragmentId, authTag, file);
    }

    private byte[] decryptAttachment(RSAKey privateDecryptionKey, UUID attachmentId, String encryptedAttachment, T transmission) {
        try {
            long startDecryption = StopWatch.start();
            byte[] decryptedAttachment = this.fitConnectService.decryptString(privateDecryptionKey, encryptedAttachment);
            LOGGER.trace("Decrypting attachment {} took {}", (Object)attachmentId, (Object)StopWatch.stop(startDecryption));
            return decryptedAttachment;
        }
        catch (DecryptionException e) {
            this.reject(transmission, new AttachmentEncryptionIssue(attachmentId));
            throw new SubmissionRequestException(e.getMessage(), e);
        }
    }

    protected abstract String downloadAttachment(T var1, UUID var2);

    protected abstract void reject(T var1, Problem var2);
}

