/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.attachments;

import dev.fitko.fitconnect.core.utils.Preconditions;
import java.util.concurrent.Semaphore;

public class ConcurrencyLimiter {
    private final Semaphore semaphore;

    public ConcurrencyLimiter(int concurrencyLimit) {
        Preconditions.checkArgumentAndThrow(concurrencyLimit <= 0, "concurrencyLimit must be > 0");
        this.semaphore = new Semaphore(concurrencyLimit, true);
    }

    public AcquiredSemaphore acquire() {
        try {
            this.semaphore.acquire();
            return new AcquiredSemaphoreImpl();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class AcquiredSemaphoreImpl
    implements AcquiredSemaphore {
        private AcquiredSemaphoreImpl() {
        }

        @Override
        public void close() {
            ConcurrencyLimiter.this.semaphore.release();
        }
    }

    public static interface AcquiredSemaphore
    extends AutoCloseable {
        @Override
        public void close() throws RuntimeException;
    }
}

