/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client.attachments;

import dev.fitko.fitconnect.api.exceptions.client.FitConnectAttachmentException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentStorageResolver {
    public static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentStorageResolver.class);
    private static final Predicate<Path> IS_INCOMING_PATH = path -> path.toString().contains(Direction.INCOMING.getName());
    private final Path basePath;

    public AttachmentStorageResolver(Path attachmentStoragePath) {
        this.basePath = Optional.ofNullable(attachmentStoragePath).orElse(this.createTempDir());
        LOGGER.info("Configured {} as attachment storage path", (Object)this.basePath);
    }

    public AttachmentStorageResolver() {
        this(null);
    }

    public Path resolveIncomingAttachmentFolder(UUID attachmentId) throws IOException {
        return this.resolveFolder(Direction.INCOMING, attachmentId);
    }

    public Path resolveOutgoingAttachmentFolder(UUID attachmentId) throws IOException {
        return this.resolveFolder(Direction.OUTGOING, attachmentId);
    }

    public void clearBasePathContents() {
        LOGGER.info("Clearing attachment storage path {}", (Object)this.basePath);
        try (Stream<Path> fileTree = Files.walk(this.basePath, new FileVisitOption[0]).sorted(Comparator.reverseOrder());){
            fileTree.filter(IS_INCOMING_PATH).forEach(AttachmentStorageResolver::deletePath);
        }
        catch (IOException | RuntimeException e) {
            throw new FitConnectAttachmentException(e.getMessage(), e);
        }
    }

    private Path resolveFolder(Direction direction, UUID id) throws IOException {
        return Files.createDirectories(this.basePath.resolve(direction.name + String.valueOf(id)), new FileAttribute[0]);
    }

    private Path createTempDir() {
        try {
            return Files.createDirectories(Path.of(TMP_DIR, new String[0]).resolve("fit-connect-attachments"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void deletePath(Path path) {
        try {
            LOGGER.debug("Deleting {} {}", (Object)(path.toFile().isDirectory() ? "directory" : "file"), (Object)path);
            Files.delete(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Direction {
        INCOMING("INCOMING_"),
        OUTGOING("OUTGOING_");

        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

