/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client;

import dev.fitko.fitconnect.api.domain.zbp.attachment.ZBPApiAttachment;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessage;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessageResponse;
import dev.fitko.fitconnect.api.domain.zbp.state.CreateState;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectZBPException;
import dev.fitko.fitconnect.client.zbp.ZBPServiceAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class ZBPClient {
    private final ZBPServiceAdapter serviceAdapter;

    public ZBPClient(ZBPServiceAdapter serviceAdapter) {
        this.serviceAdapter = serviceAdapter;
    }

    public CreateMessageResponse sendMessage(CreateMessage createMessage) {
        return this.wrapExceptions(() -> this.serviceAdapter.sendMessage(createMessage, Collections.emptyList(), null, null), "Could not send message to zbp mailbox " + String.valueOf(createMessage.getMailboxUuid()));
    }

    public CreateMessageResponse sendMessageWithAttachments(CreateMessage createMessage, List<ZBPApiAttachment> attachments) {
        return this.wrapExceptions(() -> this.serviceAdapter.sendMessage(createMessage, attachments, null, null), "Could not send message to zbp mailbox " + String.valueOf(createMessage.getMailboxUuid()));
    }

    public CreateMessageResponse sendMessage(CreateMessage createMessage, String authorCertificate, String authorToken) {
        return this.wrapExceptions(() -> this.serviceAdapter.sendMessage(createMessage, Collections.emptyList(), authorCertificate, authorToken), "Could not send message to zbp mailbox " + String.valueOf(createMessage.getMailboxUuid()));
    }

    public CreateMessageResponse sendMessageWithAttachments(CreateMessage createMessage, List<ZBPApiAttachment> attachments, String authorCertificate, String authorToken) {
        return this.wrapExceptions(() -> this.serviceAdapter.sendMessage(createMessage, attachments, authorCertificate, authorToken), "Could not send message to zbp mailbox " + String.valueOf(createMessage.getMailboxUuid()));
    }

    public void createState(CreateState createState) {
        this.wrapExceptions(() -> {
            this.serviceAdapter.createNewState(createState, null, null);
            return null;
        }, "Could not create state for application " + String.valueOf(createState.getApplicationId()));
    }

    public void createState(CreateState createState, String authorCertificate, String authorToken) {
        this.wrapExceptions(() -> {
            this.serviceAdapter.createNewState(createState, authorCertificate, authorToken);
            return null;
        }, "Could not create state for application " + String.valueOf(createState.getApplicationId()));
    }

    private <T> T wrapExceptions(Supplier<T> supplier, String errorMessage) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new FitConnectZBPException(Optional.ofNullable(e.getMessage()).orElse(errorMessage), Optional.ofNullable(e.getCause()).orElse(e));
        }
    }
}

