/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.model.cases.Cases;
import dev.fitko.fitconnect.api.domain.model.event.EventLogEntry;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.Status;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.reply.SentReply;
import dev.fitko.fitconnect.api.domain.model.submission.SentSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionForPickup;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionsForPickup;
import dev.fitko.fitconnect.api.domain.subscriber.ReceivedSubmission;
import dev.fitko.fitconnect.api.domain.subscriber.SendableReply;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectSubscriberException;
import dev.fitko.fitconnect.client.attachments.AttachmentStorageResolver;
import dev.fitko.fitconnect.client.subscriber.ReplySender;
import dev.fitko.fitconnect.client.subscriber.SubmissionReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriberClient.class);
    private static final int DEFAULT_SUBMISSION_LIMIT = 25;
    private static final int DEFAULT_CASE_LIMIT = 500;
    private final FitConnectService fitConnectService;
    private final SubmissionReceiver submissionReceiver;
    private final ReplySender replySender;
    private final AttachmentStorageResolver attachmentStorageResolver;

    public SubscriberClient(FitConnectService fitConnectService, SubmissionReceiver submissionReceiver, ReplySender replySender, AttachmentStorageResolver attachmentStorageResolver) {
        this.fitConnectService = fitConnectService;
        this.submissionReceiver = submissionReceiver;
        this.replySender = replySender;
        this.attachmentStorageResolver = attachmentStorageResolver;
    }

    public List<SubmissionForPickup> getAvailableSubmissionsForDestination(UUID destinationId) throws FitConnectSubscriberException {
        return this.wrapExceptions(() -> this.collectAllAvailableSubmissions(new ArrayList<SubmissionForPickup>(), destinationId, 0, 25), "Submissions could not be retrieved");
    }

    public List<SubmissionForPickup> getAvailableSubmissionsForDestination(UUID destinationId, int offset, int limit) throws FitConnectSubscriberException {
        SubmissionsForPickup submissions = this.wrapExceptions(() -> this.fitConnectService.getAvailableSubmissions(destinationId, offset, limit), "Submissions could not be retrieved");
        LOGGER.info("Received {} submission(s) for destination {}", (Object)submissions.getCount(), (Object)destinationId);
        return submissions.getSubmissions();
    }

    public ReceivedSubmission requestSubmission(SubmissionForPickup submission) throws FitConnectSubscriberException {
        return this.requestSubmission(submission.getSubmissionId());
    }

    public ReceivedSubmission requestSubmission(UUID submissionId) throws FitConnectSubscriberException {
        return this.wrapExceptions(() -> this.submissionReceiver.receiveSubmission(submissionId), "Submission could not be retrieved");
    }

    public void rejectSubmission(SubmissionForPickup submissionForPickup, List<Problem> rejectionProblems) throws FitConnectSubscriberException {
        this.wrapExceptions(() -> {
            this.fitConnectService.rejectSubmission(EventPayload.forRejectEvent(submissionForPickup, rejectionProblems));
            return null;
        }, "Could not reject submission");
    }

    public ValidationResult validateCallback(String hmac, Long timestampInSec, String httpBody, String callbackSecret) throws FitConnectSubscriberException {
        return this.wrapExceptions(() -> this.fitConnectService.validateCallback(hmac, timestampInSec, httpBody, callbackSecret), "Callback validation failed");
    }

    public Status getSubmissionStatus(UUID destinationId, UUID caseId, UUID submissionId) throws FitConnectSubscriberException {
        return this.wrapExceptions(() -> this.fitConnectService.getStatus(new SentSubmission(destinationId, caseId, submissionId)), "Status for submission not available");
    }

    public List<EventLogEntry> getEventLogForSubmission(UUID destinationId, UUID caseId, UUID submissionId) {
        return this.fitConnectService.getEventLogForSubmission(destinationId, caseId, submissionId, null);
    }

    public List<EventLogEntry> getEventLogForCase(UUID destinationId, UUID caseId) {
        return this.fitConnectService.getEventLogForCase(destinationId, caseId, null);
    }

    public SentReply sendReply(SendableReply reply) {
        return this.wrapExceptions(() -> this.replySender.sendReply(reply), "Sending reply for case " + String.valueOf(reply.getCaseId()) + " failed.");
    }

    public Status getReplyStatus(SentReply reply) throws FitConnectSubscriberException {
        return this.wrapExceptions(() -> this.fitConnectService.getStatus(reply), "Status for reply not available");
    }

    public Cases listCases() throws FitConnectSubscriberException {
        return this.listCases(500, 0);
    }

    public Cases listCases(int limit, int offset) throws FitConnectSubscriberException {
        return this.wrapExceptions(() -> this.fitConnectService.listCases(limit, offset), "Loading active cases failed.");
    }

    public void clearAttachmentStorage() {
        this.wrapExceptions(() -> {
            this.attachmentStorageResolver.clearBasePathContents();
            return null;
        }, "Clearing attachment storage directory failed");
    }

    private List<SubmissionForPickup> collectAllAvailableSubmissions(List<SubmissionForPickup> submissions, UUID destinationId, int offset, int limit) {
        SubmissionsForPickup availableSubmissions = this.fitConnectService.getAvailableSubmissions(destinationId, offset, limit);
        submissions.addAll(availableSubmissions.getSubmissions());
        if (availableSubmissions.getTotalCount() > offset + limit) {
            return this.collectAllAvailableSubmissions(submissions, destinationId, offset + limit, limit);
        }
        return submissions;
    }

    private <T> T wrapExceptions(Supplier<T> supplier, String errorMessage) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new FitConnectSubscriberException(Optional.ofNullable(e.getMessage()).orElse(errorMessage), Optional.ofNullable(e.getCause()).orElse(e));
        }
    }
}

